<?php

return [
    'transport' => 'Transport',
    'stoppage' => [
        'stoppage' => 'Transport Stoppage',
        'stoppages' => 'Transport Stoppages',
        'module_title' => 'List all Transport Stoppage',
        'module_description' => 'Manage all Transport Stoppage',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'route' => [
        'route' => 'Transport Route',
        'routes' => 'Transport Routes',
        'module_title' => 'List all Transport Route',
        'module_description' => 'Manage all Transport Route',
        'arrival_time_should_less_than_departure_time' => 'Arrival time should be less than departure time.',
        'duplicate_route_with_same_vehicle_and_time' => 'Route with same vehicle and time already exists.',
        'timing' => 'Timing',
        'passenger' => 'Passenger',
        'passengers' => 'Passengers',
        'arrival_stoppages' => 'Arrival Stoppages',
        'departure_stoppages' => 'Departure Stoppages',
        'props' => [
            'name' => 'Name',
            'title' => 'Title',
            'max_capacity' => 'Max Capacity',
            'direction' => 'Direction',
            'arrival_starts_at' => 'Arrival Starts At',
            'departure_starts_at' => 'Departure Starts At',
            'arrival_time' => 'Arrival Time',
            'departure_time' => 'Departure Time',
            'waiting_time' => 'Waiting Time',
            'description' => 'Description',
            'arrival_time' => 'Arrival Time',
            'departure_time' => 'Departure Time',
            'duration_to_destination' => 'Duration To Destination',
        ],
    ],
    'circle' => [
        'circle' => 'Transport Circle',
        'circles' => 'Transport Circles',
        'module_title' => 'List all Transport Circle',
        'module_description' => 'Manage all Transport Circle',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
        'direction' => 'Direction',
        'directions' => [
            'arrival' => 'Arrival',
            'departure' => 'Departure',
            'roundtrip' => 'Round Trip',
        ],
    ],
    'fee' => [
        'fee' => 'Transport Fee',
        'fees' => 'Transport Fees',
        'module_title' => 'List all Transport Fee',
        'module_description' => 'Manage all Transport Fee',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
            'arrival_amount' => 'Arrival amount',
            'departure_amount' => 'Departure amount',
            'roundtrip_amount' => 'Roundtrip amount',
        ],
    ],
    'vehicle' => [
        'vehicle' => 'Vehicle',
        'vehicles' => 'Vehicles',
        'module_title' => 'List all Vehicles',
        'module_description' => 'Manage all Vehicles',
        'registration_info' => 'Registration Info',
        'owner_info' => 'Owner Info',
        'driver_info' => 'Driver Info',
        'disposal_info' => 'Disposal Info',
        'duplicate_vehicle' => 'Vehicle with this registration number already exists.',
        'current_log' => 'Current Reading',
        'current_week_running' => 'Current Week Running',
        'current_month_running' => 'Current Month Running',
        'props' => [
            'name' => 'Name',
            'registration_number' => 'Registration Number',
            'registration_date' => 'Registration Date',
            'registration_place' => 'Registration Place',
            'model_number' => 'Model Number',
            'make' => 'Make',
            'type' => 'Type',
            'class' => 'Class',
            'cubic_capacity' => 'Cubic Capacity',
            'chassis_number' => 'Chassis Number',
            'engine_number' => 'Engine Number',
            'color' => 'Color',
            'fuel_type' => 'Fuel Type',
            'fuel_capacity' => 'Fuel Capacity',
            'seating_capacity' => 'Seating Capacity',
            'max_seating_allowed' => 'Max Seating Allowed',
            'ownership' => 'Ownership',
            'ownership_date' => 'Ownership Date',
            'owner_name' => 'Owner Name',
            'owner_address' => 'Owner Address',
            'owner_phone' => 'Owner Phone',
            'owner_email' => 'Owner Email',
            'driver_name' => 'Driver Name',
            'driver_address' => 'Driver Address',
            'driver_phone' => 'Driver Phone',
            'helper_name' => 'Helper Name',
            'helper_address' => 'Helper Address',
            'helper_phone' => 'Helper Phone',
            'is_sold' => 'Is Sold',
            'buyer_name' => 'Buyer Name',
            'buyer_address' => 'Buyer Address',
            'buyer_phone' => 'Buyer Phone',
            'buyer_email' => 'Buyer Email',
            'selling_price' => 'Selling Price',
            'selling_date' => 'Selling Date',
        ],
        'ownerships' => [
            'owned' => 'Owned',
            'rented' => 'Rented',
        ],
        'type' => [
            'type' => 'Vehicle Type',
            'types' => 'Vehicle Types',
            'module_title' => 'Manage all Vehicle Types',
            'module_description' => 'List all Vehicle Types',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'document_type' => [
            'document_type' => 'Document Type',
            'document_types' => 'Document Types',
            'module_title' => 'Manage all Vehicle Document Types',
            'module_description' => 'List all Vehicle Document Types',
            'props' => [
                'name' => 'Name',
                'number' => 'Number',
                'number_format' => 'Number Format',
                'expiry_date' => 'Expiry Date',
                'alert_days_before_expiry' => 'Days to Alert Before Expiry',
                'description' => 'Description',
            ],
        ],
        'trip_purpose' => [
            'trip_purpose' => 'Trip Purpose',
            'trip_purposes' => 'Trip Purposes',
            'module_title' => 'Manage all Vehicle Trip Purposes',
            'module_description' => 'List all Vehicle Trip Purposes',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'case_type' => [
            'case_type' => 'Case Type',
            'case_types' => 'Case Types',
            'module_title' => 'Manage all Vehicle Case Types',
            'module_description' => 'List all Vehicle Case Types',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'expense_type' => [
            'expense_type' => 'Expense Type',
            'expense_types' => 'Expense Types',
            'module_title' => 'Manage all Vehicle Expense Types',
            'module_description' => 'List all Vehicle Expense Types',
            'props' => [
                'name' => 'Name',
                'next_due_date' => 'Next Due Date',
                'quantity' => 'Quantity',
                'document' => 'Document',
                'description' => 'Description',
            ],
        ],
        'incharge' => [
            'incharge' => 'Incharge',
            'incharge_short' => 'Incharge',
            'incharges' => 'Incharges',
            'module_title' => 'List all Vehicle Incharges',
            'module_description' => 'Manage all Vehicle Incharges',
            'type' => 'Type',
            'types' => [
                'supervisor' => 'Supervisor',
                'driver' => 'Driver',
                'conductor' => 'Conductor',
                'helper' => 'Helper',
                'other' => 'Other',
            ],
        ],
        'fuel_types' => [
            'petrol' => 'Petrol',
            'diesel' => 'Diesel',
            'cng' => 'CNG',
            'electrical' => 'Electrical',
        ],
        'fuel_record' => [
            'fuel_record' => 'Fuel Record',
            'fuel_records' => 'Fuel Records',
            'module_title' => 'List all Vehicle Fuel Records',
            'module_description' => 'Manage all Vehicle Fuel Records',
            'record_exists' => 'Fuel record with same details already exists.',
            'previous_mileage' => 'Previous Mileage :attribute Km/l',
            'could_not_delete_intermediate_record' => 'Could not delete intermediate record.',
            'must_be_gt_previous_log' => 'Log must be greater than previous log :attribute on :date.',
            'must_be_lt_next_log' => 'Log must be less than next log :attribute on :date.',
            'props' => [
                'quantity' => 'Quantity',
                'price_per_unit' => 'Price Per Unit',
                'log' => 'Log (Km)',
                'previous_log' => 'Previous Log (Km)',
                'date' => 'Date',
                'cost' => 'Cost',
                'bill_number' => 'Bill Number',
                'distance_covered' => 'Distance Covered (Km)',
                'mileage' => 'Mileage (Km/l)',
                'remarks' => 'Remarks',
            ],
        ],
        'case_record' => [
            'case_record' => 'Case Record',
            'case_records' => 'Case Records',
            'module_title' => 'List all Vehicle Case Records',
            'module_description' => 'Manage all Vehicle Case Records',
            'props' => [
                'type' => 'Type',
                'code_number' => 'Case #',
                'title' => 'Title',
                'date' => 'Date',
                'penalty' => 'Penalty',
                'location' => 'Location',
                'description' => 'Description',
                'action' => 'Action',
            ],
        ],
        'expense_record' => [
            'expense_record' => 'Expense Record',
            'expense_records' => 'Expense Records',
            'module_title' => 'List all Vehicle Expense Records',
            'module_description' => 'Manage all Vehicle Expense Records',
            'props' => [
                'code_number' => 'Expense #',
                'type' => 'Type',
                'quantity' => 'Quantity',
                'unit' => 'Unit',
                'price_per_unit' => 'Price Per Unit',
                'amount' => 'Amount',
                'date' => 'Date',
                'log' => 'Log',
                'next_due_date' => 'Next Due Date',
                'remarks' => 'Remarks',
            ],
        ],
        'service_center' => [
            'service_center' => 'Service Center',
            'service_centers' => 'Service Centers',
            'module_title' => 'List all Vehicle Service Centers',
            'module_description' => 'Manage all Vehicle Service Centers',
            'props' => [
                'name' => 'Name',
                'phone' => 'Phone',
                'email' => 'Email',
                'contact_person' => 'Contact Person',
                'contact_person_phone' => 'Contact Person Phone',
                'contact_person_email' => 'Contact Person Email',
                'address' => 'Address',
            ],
        ],
        'service_record' => [
            'service_record' => 'Service Record',
            'service_records' => 'Service Records',
            'module_title' => 'List all Vehicle Service Records',
            'module_description' => 'Manage all Vehicle Service Records',
            'props' => [
                'amount' => 'Amount',
                'date' => 'Date',
                'log' => 'Log',
                'next_due_date' => 'Next Due Date',
                'next_due_log' => 'Next Due Log',
                'remarks' => 'Remarks',
            ],
        ],
        'trip_record' => [
            'trip_record' => 'Trip Record',
            'trip_records' => 'Trip Records',
            'module_title' => 'List all Vehicle Trip Records',
            'module_description' => 'Manage all Vehicle Trip Records',
            'log_should_be_greater_than_previous_record' => 'Log should be greater than previous log :attribute.',
            'props' => [
                'date' => 'Date',
                'log' => 'Log',
                'purpose' => 'Purpose',
                'remarks' => 'Remarks',
            ],
        ],
        'document' => [
            'document' => 'Document',
            'documents' => 'Documents',
            'module_title' => 'List all Vehicle Documents',
            'module_description' => 'Manage all Vehicle Documents',
            'expired' => 'Expired',
            'expiring_in_days' => 'Expiring in :attribute day(s)',
            'props' => [
                'title' => 'Title',
                'type' => 'Type',
                'number' => 'Number',
                'expiry_in_days' => 'Expiry in Days',
                'issue_date' => 'Issue Date',
                'start_date' => 'Issue Date',
                'end_date' => 'Expiry Date',
                'number' => 'Number',
                'issue_date' => 'Issue Date',
                'start_date' => 'Validity Start',
                'end_date' => 'Validity End',
                'issue_date_between' => 'Issue Date Between',
                'start_date_between' => 'Validity Start Between',
                'end_date_between' => 'Validity End Between',
                'description' => 'Description',
            ],
        ],
        'config' => [
            'config' => 'Config',
            'props' => [],
        ],
    ],
    'config' => [
        'config' => 'Config',
        'props' => [
            'route_in_dashboard' => 'Transport Route in Dashboard',
        ],
    ],
    'report' => [
        'report' => 'Report',
        'reports' => 'Reports',
        'batch_wise_route' => [
            'batch_wise_route' => 'Batch Wise Route Report',
            'module_title' => 'List all Batch Wise Route Report',
            'module_description' => 'Manage all Batch Wise Route Report',
        ],
        'route_wise_student' => [
            'route_wise_student' => 'Route Wise Student Report',
            'module_title' => 'List all Route Wise Student Report',
            'module_description' => 'Manage all Route Wise Student Report',
        ],
    ],
];
