<?php

return [
    'student' => 'Student',
    'students' => 'Students',
    'active_students' => 'Active Students',
    'module_title' => 'List all Students',
    'course_wise_strength' => 'Course Wise Strength',
    'registration_summary' => 'Registration Summary',
    'admission_vs_strength' => 'Admission vs Strength',
    'registration_vs_strength' => 'Registration vs Strength',
    'gender_wise_strength' => 'Gender Wise Strength',
    'module_description' => 'Get list of all the students, filter them with different criteria and manage their records.',
    'set_fee_info' => 'Fee is not set for this student.',
    'could_not_delete_with_multiple_records' => 'Could not delete student if already promoted.',
    'multiple_records_found' => 'Multiple records found for this student.',
    'could_not_delete_with_paid_fee' => 'Could not delete student if fee is paid.',
    'period_not_allowed' => 'Student is not allowed to access this period.',
    'bulk_update' => 'Bulk Student Update',
    'bulk_create_user_account' => 'Bulk Create User Account',
    'bulk_update_user_account' => 'Bulk Update User Account',
    'sibling' => [
        'sibling' => 'Sibling',
        'module_title' => 'List all Siblings',
        'module_description' => 'Manage all Siblings',
        'report' => 'Sibling Report',
    ],
    'statuses' => [
        'cancelled' => 'Cancelled',
        'studying' => 'Studying',
        'transferred' => 'Transferred',
    ],
    'types' => [
        'new' => 'New Student',
        'old' => 'Old Student',
    ],
    'props' => [
        'status' => 'Status',
        'name' => 'Student Name',
        'name_or_code_number' => 'Name or Admission Number',
        'parent' => 'Parent',
        'roll_number' => 'Roll Number',
        'start_date' => 'Start Date',
        'end_date' => 'End Date',
        'type' => 'Student Type',
    ],
    'config' => [
        'config' => 'Config',
        'info' => 'Student Config',
        'general' => 'General Config',
        'attendance' => 'Attendance Config',
        'fee' => 'Fee Config',
        'service' => 'Service Config',
        'mobile_payment_types' => [
            'browser_based' => 'Browser Based Payment',
            'webview_based' => 'Webview Based Payment',
        ],
        'props' => [
            'number_prefix' => 'Admission Number Prefix',
            'number_suffix' => 'Admission Number Suffix',
            'number_digit' => 'Admission Number Digit',
            'provisional_number_prefix' => 'Provisional Admission Number Prefix',
            'provisional_number_suffix' => 'Provisional Admission Number Suffix',
            'provisional_number_digit' => 'Provisional Admission Number Digit',
            'attendance_past_day_limit' => 'No of days to mark attendance in past',
            'allow_student_to_submit_contact_edit_request' => 'Allow student to submit contact edit request',
            'enable_provisional_admission' => 'Enable Provisional Admission',
            'enable_marital_status' => 'Enable Marital Status',
            'enable_anniversary_date' => 'Enable Anniversary Date',
            'enable_unique_id_fields' => 'Enable Unique ID Fields',
            'unique_id_number1_enabled' => 'Unique ID 1 Enabled',
            'unique_id_number2_enabled' => 'Unique ID 2 Enabled',
            'unique_id_number3_enabled' => 'Unique ID 3 Enabled',
            'unique_id_number4_enabled' => 'Unique ID 4 Enabled',
            'unique_id_number5_enabled' => 'Unique ID 5 Enabled',
            'unique_id_number1_label' => 'Unique ID 1 Label',
            'unique_id_number2_label' => 'Unique ID 2 Label',
            'unique_id_number3_label' => 'Unique ID 3 Label',
            'unique_id_number4_label' => 'Unique ID 4 Label',
            'unique_id_number5_label' => 'Unique ID 5 Label',
            'unique_id_number1_required' => 'Unique ID 1 Required',
            'unique_id_number2_required' => 'Unique ID 2 Required',
            'unique_id_number3_required' => 'Unique ID 3 Required',
            'unique_id_number4_required' => 'Unique ID 4 Required',
            'unique_id_number5_required' => 'Unique ID 5 Required',
            'late_fee_waiver_till_date' => 'Late Fee waiver till date',
            'allow_flexible_installment_payment' => 'Allow flexible installment payment',
            'allow_flexible_installment_payment_info' => 'Allow making payment of any installment for fee regardles of installment sequence',
            'allow_multiple_installment_payment' => 'Allow multiple installment payment',
            'allow_multiple_installment_payment_info' => 'User can select multiple installments to pay',
            'enable_qr_code_fee_payment' => 'Enable QR Code Fee Payment',
            'payment_link_qr_code_expiry_duration' => 'Payment Link QR Code Expiry Duration (Minutes)',
            'payment_link_qr_code_expiry_duration_info' => 'No of minutes after which the payment link will expire.',
            'show_receipt_after_payment' => 'Show receipt after payment',
            'enable_qr_code_attendance' => 'Enable QR Code Attendance',
            'enable_attendance_notification_to_absentees' => 'Enable Attendance Notification to Absentees',
            'enable_attendance_notification_to_absentees_info' => 'Enabling this option will send attendance notification only to absent students. Disabling will send notification to all students.',
            'allow_student_clock_in_out' => 'Allow Student Clock In Out',
            'clock_in_time' => 'Clock In Time',
            'clock_out_time' => 'Clock Out Time',
            'has_dynamic_qr_code' => 'Use Dynamic QR Code',
            'qr_code_expiry_duration' => 'QR Code Expiry Duration (Seconds)',
            'dynamic_qr_code_tip' => 'If enabled, a new QR Code will be generated dynamically after every given duration.',
            'available_services' => 'Available Services',
            'service_request_instruction' => 'Service Request Instruction',
            'mobile_payment_type' => 'Mobile Payment Type',
        ],
    ],
    'record' => [
        'record' => 'Record',
        'module_title' => 'List all Student Records',
        'module_description' => 'Manage all Student Records',
        'changing_course_info' => 'Changing course will reset the fee if not paid. If paid then you need to edit fee.',
        'delete_fee_receipt' => 'Delete all the fee Receipt',
        'force_changing_course_info' => 'It will delete all the fee paid by the student and cannot be undone.',
        'change_history' => ':attribute batch/course change',
        'could_not_change_course_batch_and_batch_simultaneously' => 'Could not change course/batch and batch simultaneously.',
        'no_change_in_batch' => 'No change in batch.',
        'no_change_in_course' => 'No change in course.',
        'no_change_in_course_batch' => 'No change in course batch.',
        'could_not_change_batch_with_different_fee_allocation' => 'Could not change batch with different fee allocation.',
        'could_not_change_course_with_different_fee_allocation' => 'Could not change course with different fee allocation.',
        'could_not_cancel_previous_admission' => 'Could not cancel admission if promoted.',
        'could_not_cancel_previous_promotion' => 'Could not cancel promotion if promoted to next period.',
        'could_not_cancel_if_paid' => 'Could not cancel record if fee is paid.',
        'code_number_same_as_previous_code_number' => 'The admission number is same as previous admission number.',
        'could_not_edit_code_number_for_provisional_student' => 'Could not edit admission number for provisional student.',
        'code_number_format_mismatch' => 'The admission number format does not match.',
        'code_number_already_exists' => 'The admission number already exists.',
        'props' => [
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'promotion_date' => 'Promotion Date',
            'remarks' => 'Remarks',
        ],
    ],
    'mentor' => [
        'mentor' => 'Mentor',
    ],
    'audience_types' => [
        'all' => 'All Student',
        'division_wise' => 'Division Wise Student',
        'course_wise' => 'Course Wise Student',
        'batch_wise' => 'Batch Wise Student',
        'student_wise' => 'Student Wise',
    ],
    'custom_fee' => [
        'custom_fee' => 'Custom Fee',
        'module_title' => 'List all Custom Fee',
        'module_description' => 'Manage all Custom Fee',
    ],
    'fee' => [
        'fee' => 'Fee',
        'with_concession' => 'With Concession',
        'without_concession' => 'Without Concession',
        'total' => 'Total Fee',
        'paid' => 'Paid Fee',
        'balance' => 'Balance Fee',
        'opted_fee' => 'Opted Fee',
        'receipt' => 'Fee Receipt',
        'installment_wise' => 'Installment Wise',
        'group_wise' => 'Group Wise',
        'failed_transactions' => 'Failed Transactions',
        'online_failed_transactions' => 'Online Failed Transactions',
        'guest_payment_status_info' => 'Enter your transaction reference number to check the status of your payment.',
        'could_not_refresh_old_payment_status' => 'Could not refresh payment status as it is older than :attribute days.',
        'multi_installment' => 'Multi Installment',
        'authorized_signatory' => 'Authorized Signatory',
        'custom_fee' => 'Custom Fee',
        'head_wise' => 'Fee Head Wise',
        'group_wise' => 'Fee Group Wise',
        'bank_transfer' => 'Bank Transfer',
        'locked_info' => 'This fee is locked to disable payment at :datetime. Unlock to make payment.',
        'calculation_mismatch' => 'There is some calculation mismatch in the fee records. Please contact the vendor for support.',
        'already_allocated' => 'Fee is already allocated for some students.',
        'could_not_update_if_multiple_fee_structures' => 'Could not update fee allocation if multiple fee structures are found.',
        'fee_structure_info' => 'Leave this field blank to use default batch/course wise fee structure.',
        'could_not_change_transport_if_paid' => 'Could not change transport fee if paid.',
        'could_not_change_transport_if_paid_more' => 'Could not change transport fee if paid (:paid) more than new transport fee (:new).',
        'installment_fee_mismatch' => 'Installment fee :installment mismatch against sum of fee records :records.',
        'bank_transfer_uploaded' => 'Bank Transfer :code_number :amount uploaded, it will be processed after verification.',
        'bank_transfer_already_uploaded' => 'Bank Transfer for this fee is already uploaded and currently pending for verification.',
        'registration_info' => 'Registration Fee :fee paid against :code_number (:date).',
        'fee_not_set' => 'Fee is not set for this student.',
        'set_fee_info' => 'Fee is not set for this student.',
        'no_allocation_found' => 'No fee allocation found to remove.',
        'could_not_remove_paid_allocation' => 'Could not remove fee allocation as fee is paid.',
        'could_not_set_concession_for_no_concession' => 'Could not set concession for no concession installment.',
        'could_not_update_concession_for_paid_fee' => 'Could not update concession for paid fee.',
        'custom_amount_lt_concession' => 'Custom amount cannot be less than concession amount.',
        'could_not_set_custom_concession_for_custom_fee' => 'Could not set custom concession for custom fee.',
        'could_not_set_custom_concession_for_paid_fee' => 'Could not set custom concession for paid fee.',
        'could_not_set_custom_concession_for_existing_concession' => 'Could not set custom concession if concession already exists.',
        'could_not_set_concession_for_existing_custom_concession' => 'Could not set concession if custom concession already exists.',
        'multi_installment_payment_info' => 'The payment is made for multiple installments.',
        'paid_online' => 'Fee payment of :amount successful. Reference number :reference.',
        'total_mismatch' => 'Total amount mismatch.',
        'amount_mismatch' => 'There is some issue with the payment. Please use :attribute for future reference.',
        'head_amount_mismatch' => 'Amount mismatch for :attribute.',
        'total_head_amount_mismatch' => 'Input amount :input does not match with total payable amount :total.',
        'concession_amount_gt_balance' => 'Concession amount :amount is greater than balance :balance for :installment.',
        'could_not_update_payment_status' => 'Could not update payment status.',
        'props' => [
            'amount' => 'Amount',
            'date' => 'Date',
            'due_date' => 'Due Date',
            'additional_charge' => 'Additional Charge',
            'additional_charge_label' => 'Label',
            'additional_charge_amount' => 'Amount',
            'additional_discount' => 'Additional Discount',
            'additional_discount_label' => 'Label',
            'additional_discount_amount' => 'Amount',
            'remarks' => 'Remarks',
        ],
        'could_not_pay_lt_zero' => 'Installment amount cannot be less than zero.',
        'amount_cannot_be_zero' => 'Amount cannot be zero.',
        'could_not_change_payment_date' => 'Could not change payment date.',
        'could_not_customize_late_fee' => 'Could not change late fee.',
        'could_not_apply_late_fee_without_installment' => 'Could not apply late fee without installment.',
        'could_not_apply_additional_fee_without_installment' => 'Could not apply additional fee without installment.',
        'partial_payment_not_allowed_for_custom_late_fee' => 'Partial payment is not allowed for custom late fee.',
        'partial_payment_not_allowed_for_late_fee' => 'Partial payment is not allowed for late fee.',
        'partial_payment_not_allowed_for_additional_fee' => 'Partial payment is not allowed for additional fee.',
        'previous_installment_due' => 'Could not make payment of this installment as previous installment is due.',
        'no_payable_balance' => 'Could not find correct balance amount for payment. Please use :attribute for future reference.',
        'no_payable_fee' => 'Could not find any payable fee installment.',
        'could_not_make_partial_payment' => 'Could not make partial payment.',
        'could_not_make_excess_payment' => 'Amount cannot be greater than balance :attribute.',
        'could_not_pay_late_fee_if_balance_mismatch' => 'Late fee cannot be paid if balance :attribute mismatch.',
        'can_apply_late_fee_in_last_installment' => 'Late fee can be applied in last installment only.',
        'could_not_set_if_fee_already_set' => 'Fee is already set.',
        'could_not_reset_if_fee_paid' => 'Could not reset fee as fee is paid.',
        'could_not_edit_if_fee_paid' => 'Could not edit fee as fee is paid.',
        'could_not_reset_if_fee_not_set' => 'Fee is not yet set.',
        'could_not_cancel_online_payment' => 'Could not cancel online payment.',
        'already_cancelled' => 'Payment is already cancelled.',
        'previous_due_info' => 'You have due amount of :amount + applicable late fee for :period.',
    ],
    'fee_refund' => [
        'fee_refund' => 'Fee Refund',
        'fee_refunds' => 'Fee Refunds',
        'module_title' => 'List all Fee Refund',
        'module_description' => 'Manage all Fee Refund',
        'props' => [
            'amount' => 'Amount',
            'total' => 'Total',
            'date' => 'Date',
            'remarks' => 'Remarks',
        ],
    ],
    'payment' => [
        'payment' => 'Payment',
        'payments' => 'Payments',
        'online' => 'Online Payment',
        'instruction' => 'Payment Instruction',
        'invalid_signature' => 'Invalid payment signature.',
        'payment_instruction_alert' => 'Please read the instruction carefully before proceeding.',
        'could_not_make_payment_as_fee_locked' => 'Could not make payment as fee is locked.',
        'qr_code_fee_payment_not_enabled' => 'QR Code fee payment is not enabled.',
        'payment_gateway_not_enabled' => 'No payment gateway is enabled.',
        'already_processed' => 'This payment is already processed.',
        'payment_completed' => 'Payment completed successfully.',
        'link_expired' => 'Payment link expired.',
        'payment_link_qr_code' => 'Payment Link QR Code',
        'payment_link_qr_code_expiry_duration' => 'Payment Link QR Code will expire on :expiryDate.',
        'payment_link_qr_code_expired' => 'Payment Link QR Code has expired.',
        'payment_link_expires_in' => 'Payment Link Expires In',
        'pay' => 'Pay',
        'props' => [
            'remarks' => 'Remarks',
        ],
    ],
    'transfer_certificate' => [
        'transfer_certificate' => 'Transfer Certificate',
        'verification' => 'TC Verification',
        'module_title' => 'List all Transfer Certificates',
        'module_description' => 'Manage all Transfer Certificates',
    ],
    'admission' => [
        'admission' => 'Admission',
        'admissions' => 'Admissions',
        'provisional_admission' => 'Provisional Admission',
        'provisional_admission_info' => 'This admission is provisional and will be converted to regular admission after verification.',
        'convert_to_regular' => 'Convert to Regular Admission',
        'module_title' => 'List all Admissions',
        'module_description' => 'Manage all Admissions',
        'date_lt_registration_date' => 'Admission date cannot be less than registration date :attribute.',
        'already_cancelled' => 'Admission is already cancelled.',
        'types' => [
            'provisional' => 'Provisional Admission',
            'regular' => 'Regular Admission',
        ],
        'props' => [
            'type' => 'Admission Type',
            'number' => 'Number',
            'code_number' => 'Admission Number',
            'code_number_format' => 'Admission Number Format',
            'code_number_sno' => 'Admission Number S.No.',
            'provisional_code_number' => 'Provisional Admission Number',
            'type' => 'Admission Type',
            'date' => 'Date of Admission',
            'remarks' => 'Admission Remarks',
        ],
    ],
    'transfer_request' => [
        'transfer_request' => 'Transfer Request',
        'transfer_requests' => 'Transfer Requests',
        'already_transferred' => 'Student is already transferred.',
        'module_title' => 'List all Student Transfer Requests',
        'module_description' => 'Manage all Student Transfer Requests',
        'date_before_joining' => 'Transfer request date cannot be less than joining date :attribute.',
        'date_before_promotion' => 'Transfer request date cannot be less than promotion date :attribute.',
        'duplicate_request' => 'You have already submitted a transfer request.',
        'could_not_perform_if_status_updated' => 'You cannot perform this action as status is updated.',
        'fee_due' => 'You have paid :paid of :total. Please pay the remaining amount to proceed.',
        'props' => [
            'action' => 'Action',
            'code_number' => 'Request #',
            'reason' => 'Reason',
            'status' => 'Status',
            'application' => 'Application',
            'request_date' => 'Date of Request',
            'processed_at' => 'Processed At',
            'comment' => 'Comment',
            'certificate_number' => 'Certificate Number',
        ],
        'statuses' => [
            'requested' => 'Requested',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'in_progress' => 'In Progress',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Transfer Request Number Prefix',
                'number_suffix' => 'Transfer Request Number Suffix',
                'number_digit' => 'Transfer Request Number Digit',
            ],
        ],
    ],
    'transfer' => [
        'transfer' => 'Transfer',
        'transfers' => 'Transfers',
        'module_title' => 'List all Student Transfers',
        'module_description' => 'Manage all Student Transfers',
        'already_transferred' => 'Student is already transferred.',
        'date_before_joining' => 'Transfer date cannot be less than joining date :attribute.',
        'approval_request_info' => 'A request will be submitted for approval to transfer the student.',
        'date_before_promotion' => 'Transfer date cannot be less than promotion date :attribute.',
        'already_promoted' => 'Student is already promoted to next course.',
        'could_not_perform_if_transferred' => 'You cannot perform this action as student is transferred.',
        'could_not_perform_if_transfer_request' => 'Could not perform this action if processed via transfer request.',
        'could_not_perform_if_transfer_approval_request' => 'Could not perform this action if processed via approval request.',
        'verified' => 'The transfer certificate is verified.',
        'not_verified' => 'The transfer certificate is not verified.',
        'request_submitted' => 'Transfer request submitted successfully. Please wait for approval.',
        'request_already_submitted' => 'You have already submitted a transfer request :attribute.',
        'actions' => [
            'transfer_other_team' => 'Transfer to Other Institute',
            'transfer_within_team' => 'Transfer within Institute',
        ],
        'props' => [
            'code_number' => 'Transfer Number',
            'date' => 'Date of Transfer',
            'reason' => 'Reason',
            'remarks' => 'Transfer Remarks',
            'certificate_number' => 'Certificate Number',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Transfer Number Prefix',
                'number_suffix' => 'Transfer Number Suffix',
                'number_digit' => 'Transfer Number Digit',
            ],
        ],
    ],
    'registration' => [
        'registration' => 'Registration',
        'registrations' => 'Registrations',
        'fee' => 'Registration Fee',
        'receipt' => 'Fee Receipt',
        'online' => 'Online',
        'offline' => 'Offline',
        'total_registration' => 'Total Registration',
        'initiated_registration' => 'Initiated Registration',
        'pending_registration' => 'Pending Registration',
        'approved_registration' => 'Approved Registration',
        'rejected_registration' => 'Rejected Registration',
        'converted_from_enquiry' => 'Converted from Enquiry',
        'cannot_pay_after_due_date' => 'You cannot pay after due date :attribute.',
        'fee_cannot_be_less_than_paid' => 'Registration fee cannot be less than paid amount.',
        'payment_due_date_cannot_be_less_than_registration_date' => 'Payment due date cannot be less than registration date.',
        'module_title' => 'List all Registrations',
        'module_description' => 'Manage all Registrations',
        'action' => 'Action',
        'proceed_without_payment' => 'Proceed without payment',
        'payment_date_lt_date' => 'Payment date cannot be less than registration date :attribute.',
        'could_not_edit_registration_fee' => 'Could not edit registration fee.',
        'could_not_delete_if_not_pending' => 'Only pending status registration can be deleted.',
        'could_not_edit_if_not_pending' => 'Only pending status registration can be edited.',
        'could_not_delete_transaction_if_processed' => 'Only unprocessed registration related transaction can be deleted.',
        'could_not_edit_if_paid' => 'Only unpaid registration can be edited',
        'could_not_delete_if_paid' => 'Only unpaid registration can be deleted.',
        'could_not_find_elective_subjects' => 'Could not find elective subjects :attribute for this batch.',
        'fee_unpaid' => 'Could not proceed as registration fee is not paid.',
        'rejected_info' => 'Your registration is rejected at :attribute.',
        'approved_info' => 'Your registration is approved.',
        'initiated_info' => 'This application is not yet completed.',
        'pending_verification_info' => 'Fee assigned, please wait for the verification.',
        'verification_tip' => 'I have carefully reviewed the form, and all the details have been verified and found to be correct. It is ready to proceed further.',
        'verified_info' => 'This application has been verified by :name at :datetime.',
        'payment_info' => 'Application waiting for registration fee payment.',
        'online_registration_instruction_alert' => 'Please read the instruction carefully before proceeding.',
        'assign_fee_later' => 'I will assign fee later.',
        'undo' => 'Undo',
        'verified_by' => 'Verified By',
        'admitted_by' => 'Admitted By',
        'converted_by' => 'Converted By',
        'config' => [
            'config' => 'Config',
            'info' => 'Registration Config',
            'props' => [
                'number_prefix' => 'Registration Number Prefix',
                'number_suffix' => 'Registration Number Suffix',
                'number_digit' => 'Registration Number Digit',
            ],
        ],
        'statuses' => [
            'initiated' => 'Initiated',
            'pending' => 'Pending',
            'verified' => 'Verified',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
        ],
        'actions' => [
            'approve' => 'Approve',
            'reject' => 'Reject',
        ],
        'props' => [
            'status' => 'Status',
            'type' => 'Type',
            'stage' => 'Stage',
            'date' => 'Date of Registration',
            'code_number' => 'Registration Number',
            'payment_status' => 'Payment Status',
            'payment_date' => 'Date of Payment',
            'payment_remarks' => 'Remarks',
            'rejection_remarks' => 'Remarks',
            'assigned_to' => 'Assigned To',
            'payment_due_date' => 'Payment Due Date',
            'remarks' => 'Remarks',
        ],
        'wizard' => [
            'first_step' => 'Basic',
            'second_step' => 'Photo',
            'third_step' => 'Contact',
            'fourth_step' => 'Guardian',
            'fifth_step' => 'Document',
            'sixth_step' => 'Qualification',
            'final_step' => 'Review',
        ],
    ],
    'online_registration' => [
        'online_registration' => 'Online Registration',
        'title' => 'Online Registration',
        'subtitle' => 'Register Online for Admission',
        'completed' => 'Your registration is completed. Your application number is :attribute, keep it safe for future reference.',
        'enable_registration' => 'Enable Registration',
        'invalid_otp' => 'The code entered is invalid.',
        'application' => 'Application',
        'application_number' => 'Application Number',
        'proceed_with_payment' => 'Proceed with Payment',
        'fee_already_paid' => 'Fee is already paid for this registration.',
        'invalid_amount' => 'Invalid amount for registration fee.',
        'pending_application_exists' => 'You have already submitted an application.',
        'no_batches_available' => 'No batches available for this course.',
        'received' => 'Your application is received and email needs confirmation. Please check your email :email for one time passcode.',
        'confirmed' => 'Your email is confirmed and application number is :attribute.',
        'submitted' => 'Your application is submitted and under review.',
        'already_have_application_number_info' => 'Already have application number? Click here.',
        'initiated_info' => 'This application is not yet completed.',
        'pending_info' => 'Your application is under review.',
        'rejected_info' => 'Your registration is rejected at :attribute.',
        'approved_info' => 'Your registration is approved.',
        'declaration' => 'All the information provided is true and accurate.',
        'basic_info_required' => 'Please complete basic information before updating contact details',
        'contact_info_required' => 'Please complete contact information before uploading file.',
        'upload_file_required' => 'Please upload file before submitting application.',
        'version' => 'Version',
        'versions' => [
            'default' => 'Default',
            'minimal' => 'Minimal',
        ],
        'wizard' => [
            'first_step' => 'Basic Info',
            'second_step' => 'Contact Info',
            'third_step' => 'File Upload',
            'final_step' => 'Declaration',
            'transfer_certificate' => 'Transfer Certificate',
            'marksheet' => 'Previous Marksheet',
            'declaration' => 'Declaration',
            'review' => 'Review',
            'review_content' => 'Please review the information provided below.',
            'declaration_content' => 'I hereby declare that the information provided is true and accurate.',
        ],
        'props' => [
            'number' => 'Application Number',
            'confirm' => 'Confirm',
            'code' => 'Code',
            'verify' => 'Verify',
            'date_of_submission' => 'Date of Submission',
            'place_of_submission' => 'Place of Submission',
        ],
    ],
    'roll_number' => [
        'roll_number' => 'Roll Number',
        'roll_numbers' => 'Roll Numbers',
        'auto_assign' => 'Auto Assign',
        'props' => [
            'starting_number' => 'Starting Number',
        ],
    ],
    'health_record' => [
        'health_record' => 'Health Record',
        'health_records' => 'Health Records',
        'props' => [
            'date' => 'Date',
            'general' => 'General',
            'height' => 'Height',
            'weight' => 'Weight',
            'chest' => 'Chest',
            'vision' => 'Vision',
            'left_eye' => 'Left Eye',
            'right_eye' => 'Right Eye',
            'dental' => 'Dental',
            'dental_hygiene' => 'Dental Hygiene',
        ],
    ],
    'subject' => [
        'subject' => 'Elective Subject',
        'props' => [
        ],
    ],
    'attendance' => [
        'attendance' => 'Attendance',
        'attendances' => 'Attendances',
        'migrate_attendance' => 'Migrate Attendance',
        'same_batch' => 'Student is already in this batch.',
        'student_attendance' => 'Student Attendance',
        'module_title' => 'List all Attendances',
        'module_description' => 'Manage all Attendances',
        'attendance_chart' => 'Attendance Chart',
        'absentees' => 'Absentees',
        'method' => 'Method',
        'subject_wise' => 'Subject Wise',
        'batch_wise' => 'Batch Wise',
        'session' => 'Session',
        'is_default' => 'Default',
        'could_not_mark_if_holiday' => 'Attendance cannot be marked as it is a holiday.',
        'could_not_mark_past_date' => 'Attendance cannot be marked past :attribute days.',
        'could_not_mark_in_future' => 'Attendance cannot be marked in future.',
        'holiday_force_attendance_marked' => 'Date is marked as holiday (:attribute) but attendance is marked forcefully.',
        'attendance_force_holiday_marked' => 'Date is forcefully marked as holiday.',
        'marked' => 'Attendance marked.',
        'removed' => 'Attendance removed.',
        'qr_code_expired' => 'QR Code expired.',
        'already_marked' => 'Attendance already marked.',
        'session' => 'Session',
        'props' => [
            'type' => 'Attendance Type',
            'date' => 'Date of Attendance',
        ],
        'status' => 'status',
        'statuses' => [
            'marked' => 'Marked',
            'not_marked' => 'Not Marked',
        ],
        'mark' => 'Mark',
        'mark_as_holiday' => 'Mark as Holiday',
        'holiday_reason' => 'Reason',
        'mark_all' => 'Mark all :attribute',
        'total_working_days' => 'Total Working Days',
        'types' => [
            'working_days' => 'Working Days',
            'present' => 'Present',
            'absent' => 'Absent',
            'leave' => 'Leave',
            'holiday' => 'Holiday',
            'late' => 'Late',
            'half_day' => 'Half Day',
            'early_leaving' => 'Early Leaving',
        ],
    ],
    'timesheet' => [
        'timesheet' => 'Timesheet',
        'timesheets' => 'Timesheets',
        'batch_wise' => 'Batch Wise Timesheet',
        'recently_marked' => 'You have recently marked attendance.',
        'start_time_should_less_than_end_time' => 'Start time should less than end time.',
        'already_synched' => 'Timesheet already synced.',
        'already_clocked_in' => 'You have already clocked in.',
        'not_clocked_in' => 'You have not clocked in.',
        'range_exists' => 'Timesheet already exists between :start and :end.',
        'could_not_perform_if_empty_out_at' => 'Could not perform this operation if any timesheet out time is empty.',
        'could_not_perform_if_empty_in_at' => 'Could not perform this operation if any timesheet in time is empty.',
        'module_title' => 'Manage all Timesheets',
        'module_description' => 'Timesheet is the record of student\'s attendance for a particular day.',
        'minimum_diff_between_clock_in_out' => 'Minimum difference between clock in and clock out time should be :attribute minutes.',
        'props' => [
            'manual' => 'Manual',
            'clock_in' => 'Clock In',
            'clock_out' => 'Clock Out',
            'in_at' => 'In at',
            'out_at' => 'Out at',
            'date' => 'Date',
            'duration' => 'Duration',
            'remarks' => 'Remarks',
        ],
    ],
    'fee_allocation' => [
        'fee_allocation' => 'Fee Allocation',
        'fee_allocations' => 'Fee Allocations',
        'module_title' => 'List Student Fee Allocations',
        'module_description' => 'Manage Student Fee Allocations',
        'student_type_info' => 'Leave this field blank to allocate fee based on admission date.',
        'remove_concession_info' => 'This will remove all the fee concessions assigned to the student if fee is not paid.',
        'props' => [
            'remove_concession' => 'Remove Concession',
        ],
    ],
    'promotion' => [
        'promotion' => 'Promotion',
        'promote' => 'Promote',
        'awaited_promotion' => 'Student awaited Promotion',
        'promoted' => 'Student promoted.',
        'promotion_assign_fee_tip' => 'Previous session transport circle and fee concession will be assigned automatically when you assign fee during promotion.',
        'period_date_before_current_period' => 'Next period date cannot be less than current period date.',
        'date_before_current_period' => 'Promotion date cannot be less than period date.',
        'duplicate_student_found' => 'Duplicate student found.',
        'already_cancelled' => 'Promotion is already cancelled.',
        'already_promoted' => 'Student is already promoted to next period.',
        'props' => [
            'date' => 'Promotion Date',
        ],
    ],
    'alumni' => [
        'alumni' => 'Alumni',
        'marked_as_alumni' => 'Student marked as alumni.',
        'period' => 'Alumni Period',
        'props' => [
            'date' => 'Alumni Date',
        ],
    ],
    'login' => [
        'login' => 'User Login',
    ],
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'student_accounts' => 'Student Accounts',
        'module_title' => 'Manage all Account Records',
        'module_description' => 'Keep all account related information of your students.',
    ],
    'dialogue_category' => [
        'dialogue_category' => 'Dialogue Category',
        'dialogue_categories' => 'Dialogue Categories',
        'module_title' => 'List all Dialogue Categories',
        'module_description' => 'Manage all Dialogue Categories',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'dialogue' => [
        'dialogue' => 'Dialogue',
        'dialogues' => 'Dialogues',
        'module_title' => 'Manage all Dialogue Records',
        'module_description' => 'Get all dialogues related to your students.',
        'props' => [
            'title' => 'Title',
            'description' => 'Description',
            'date' => 'Date',
            'category' => 'Category',
        ],
    ],
    'transfer_reason' => [
        'transfer_reason' => 'Transfer Reason',
        'transfer_reasons' => 'Transfer Reasons',
        'module_title' => 'List all Transfer Reasons',
        'module_description' => 'Manage all Transfer Reasons',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'registration_stage' => [
        'registration_stage' => 'Registration Stage',
        'registration_stages' => 'Registration Stages',
        'module_title' => 'List all Registration Stages',
        'module_description' => 'Manage all Registration Stages',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'enrollment_type' => [
        'enrollment_type' => 'Enrollment Type',
        'enrollment_types' => 'Enrollment Types',
        'module_title' => 'List all Enrollment Types',
        'module_description' => 'Manage all Enrollment Types',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'enrollment_status' => [
        'enrollment_status' => 'Enrollment Status',
        'enrollment_statuses' => 'Enrollment Statuses',
        'module_title' => 'List all Enrollment Statuses',
        'module_description' => 'Manage all Enrollment Statuses',
        'log_detail' => ':status at :datetime by :user',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'group' => [
        'group' => 'Student Group',
        'groups' => 'Student Groups',
        'module_title' => 'List all Student Groups',
        'module_description' => 'Manage all Student Groups',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'document_type' => [
        'document_type' => 'Document Type',
        'document_types' => 'Document Types',
        'module_title' => 'List all Document Types',
        'module_description' => 'Manage all Document Types',
        'props' => [
            'name' => 'Name',
            'number' => 'Number',
            'number_format' => 'Number Format',
            'expiry_date' => 'Expiry Date',
            'alert_days_before_expiry' => 'Days to Alert Before Expiry',
            'description' => 'Description',
        ],
    ],
    'attendance_type' => [
        'attendance_type' => 'Attendance Type',
        'attendance_types' => 'Attendance Types',
        'module_title' => 'List all Attendance Types',
        'module_description' => 'Manage all Attendance Types',
        'sub_types' => [
            'present' => 'Present',
            'absent' => 'Absent',
        ],
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'sub_type' => 'Sub Type',
            'color' => 'Color',
            'description' => 'Description',
        ],
    ],
    'could_not_edit_self_service_upload' => 'Could not edit self service upload record.',
    'document' => [
        'document' => 'Document',
        'documents' => 'Documents',
        'student_documents' => 'Student Documents',
        'module_title' => 'Manage all Student Documents',
        'module_description' => 'Categorize the documents related to your students.',
        'expired' => 'Expired',
        'expiring_in_days' => 'Expiring in :attribute day(s)',
        'props' => [
            'title' => 'Title',
            'number' => 'Number',
            'issue_date' => 'Issue Date',
            'start_date' => 'Validity Start',
            'end_date' => 'Validity End',
            'expiry_in_days' => 'Expiry in Days',
            'issue_date_between' => 'Issue Date Between',
            'start_date_between' => 'Validity Start Between',
            'end_date_between' => 'Validity End Between',
            'is_submitted_original' => 'Submitted Original',
            'description' => 'Description',
        ],
    ],
    'qualification_level' => [
        'qualification_level' => 'Qualification Level',
        'module_title' => 'Manage all Qualification Levels',
        'module_description' => 'Qualification levels are the standards of different programs the institutes can offer.',
        'module_example' => 'Graduate, Post Graduate, Doctorate are some examples of Qualification Levels.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'qualification' => [
        'qualification' => 'Qualification',
        'qualifications' => 'Qualifications',
        'student_qualifications' => 'Student Qualifications',
        'module_title' => 'Manage all Student Qualification Records',
        'module_description' => 'Keep the documents related to your student\'s qualification.',
        'props' => [
            'course' => 'Course',
            'session' => 'Session',
            'institute' => 'Institute',
            'previous_institute' => 'Previous Institute',
            'institute_address' => 'Institute Address',
            'type' => 'Type',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'affiliated_to' => 'Affiliated To',
            'result' => 'Result',
            'marks' => 'Marks',
            'total_marks' => 'Total Marks',
            'obtained_marks' => 'Obtained Marks',
            'failed_subjects' => 'Failed Subjects',
            'failed_subject_info' => 'If failed in any subject, please mention the subject name here.',
            'is_submitted_original' => 'Submitted Original',
        ],
        'results' => [
            'pass' => 'Pass',
            'fail' => 'Fail',
            'reappear' => 'Reappear',
            'awaiting_result' => 'Awaiting Result',
            'other' => 'Other',
        ],
    ],
    'leave_category' => [
        'leave_category' => 'Leave Category',
        'leave_categories' => 'Leave Categories',
        'module_title' => 'List all Leave Categories',
        'module_description' => 'Manage all Leave Categories',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'leave_request' => [
        'leave_request' => 'Leave Request',
        'leave_requests' => 'Leave Requests',
        'student_leave_request' => 'Student Leave Request',
        'module_title' => 'List all Leave Requests',
        'module_description' => 'Manage all Leave Requests',
        'date_before_joining' => 'Leave date cannot be less than joining date :attribute.',
        'date_before_promotion' => 'Leave date cannot be less than promotion date :attribute.',
        'range_exists' => 'Leave request for the student already exists between :start and :end.',
        'could_not_perform_if_status_updated' => 'Could not perform this operation if status is already updated.',
        'could_not_perform_for_past_date' => 'Could not perform this operation for past date.',
        'statuses' => [
            'requested' => 'Requested',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
        ],
        'props' => [
            'category' => 'Category',
            'requester' => 'Requester',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'status' => 'Status',
            'reason' => 'Reason',
        ],
    ],
    'service_allocation' => [
        'service_allocation' => 'Service Allocation',
        'service_allocations' => 'Service Allocations',
        'module_title' => 'List all Service Records',
        'module_description' => 'Manage all Service Records',
    ],
    'service' => [
        'service' => 'Service',
        'services' => 'Services',
    ],
    'service_request' => [
        'service_request' => 'Service Request',
        'service_requests' => 'Service Requests',
        'module_title' => 'List all Service Requests',
        'module_description' => 'Manage all Service Requests',
        'already_opted_in' => 'Student has already opted in for this service.',
        'already_opted_out' => 'Student has already opted out for this service.',
        'could_not_perform_for_past_date' => 'Could not perform this operation for past date.',
        'could_not_perform_if_status_updated' => 'Could not perform this operation if status is already updated.',
        'date_before_joining' => 'Service request date cannot be less than joining date :attribute.',
        'date_before_promotion' => 'Service request date cannot be less than promotion date :attribute.',
        'already_requested' => 'Service request for the student already exists on :attribute.',
        'props' => [
            'code_number' => 'Code Number',
            'type' => 'Type',
            'requester' => 'Requester',
            'request_type' => 'Request Type',
            'date' => 'Date',
            'description' => 'Description',
            'comment' => 'Comment',
            'remarks' => 'Remarks',
            'status' => 'Status',
            'action' => 'Action',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Service Request Number Prefix',
                'number_suffix' => 'Service Request Number Suffix',
                'number_digit' => 'Service Request Number Digit',
            ],
        ],
    ],
    'edit_request' => [
        'edit_request' => 'Edit Request',
        'module_title' => 'List all Edit Requests',
        'module_description' => 'Manage all Edit Requests for Student Information',
        'edit_info' => 'If you want to edit any information, you can submit a request here.',
        'upload_document_info' => 'You can also upload document for proof of your edit request.',
        'submitted' => 'Your request for edit student information is submitted and applied after approval.',
        'already_pending' => 'You have already submitted a request for edit student information.',
        'request_by' => 'Request By',
        'request_by_name' => 'Request By :attribute',
        'already_processed' => 'This request is already processed.',
        'statuses' => [
            'pending' => 'Pending',
            'approve' => 'Approve',
            'reject' => 'Reject',
        ],
        'props' => [
            'action' => 'Action',
            'comment' => 'Comment',
            'status' => 'Status',
        ],
    ],
    'report' => [
        'report' => 'Report',
        'reports' => 'Reports',
        'batch_wise_attendance' => [
            'batch_wise_attendance' => 'Batch wise Attendance Report',
            'module_title' => 'List all Batch wise Attendance',
            'module_description' => 'Manage all Batch wise Attendance',
        ],
        'subject_wise_attendance' => [
            'subject_wise_attendance' => 'Subject wise Attendance Report',
            'module_title' => 'List all Subject wise Attendance',
            'module_description' => 'Manage all Subject wise Attendance',
        ],
        'date_wise_attendance' => [
            'date_wise_attendance' => 'Date wise Attendance Report',
            'module_title' => 'List all Date wise Attendance',
            'module_description' => 'Manage all Date wise Attendance',
        ],
        'subject_wise_student' => [
            'subject_wise_student' => 'Subject wise Student Report',
            'module_title' => 'List all Subject wise Student',
            'module_description' => 'Manage all Subject wise Student',
        ],
        'daily_access_report' => [
            'daily_access_report' => 'Daily Access Report',
            'module_title' => 'Get Daily Access Reports',
            'batch_wise_active_students' => 'Batch wise Active Students',
            'date_range_exceeded' => 'Date range should not exceed :attribute days.',
            'module_description' => 'Generate daily access reports for students/guardians',
        ],
    ],
];
