<?php

return [
    'reception' => 'Reception',
    'config' => [
        'config' => 'Config',
    ],
    'correspondence' => [
        'correspondence' => 'Correspondence',
        'correspondences' => 'Correspondences',
        'module_title' => 'Manage all Correspondences',
        'module_description' => 'Correspondences are the documents that are sent or received by the institution.',
        'types' => [
            'inward' => 'Inward',
            'outward' => 'Outward',
        ],
        'modes' => [
            'by_person' => 'By Person',
            'by_post' => 'By Post',
            'email' => 'Email',
            'whatsapp' => 'Whatsapp',
        ],
        'props' => [
            'sender' => 'Sender',
            'receiver' => 'Receiver',
            'sender_title' => 'Sender Title',
            'sender_address' => 'Sender Address',
            'receiver_title' => 'Receiver Title',
            'receiver_address' => 'Receiver Address',
            'type' => 'Type',
            'mode' => 'Mode',
            'date' => 'Date',
            'reference' => 'Reference',
            'letter_number' => 'Letter Number',
            'remarks' => 'Remarks',
        ],
        'config' => [
            'config' => 'Config',
        ],
    ],
    'online_enquiry' => [
        'online_enquiry' => 'Online Enquiry',
        'title' => 'Online Enquiry Form',
        'subtitle' => 'Please fill the form below to submit your enquiry.',
        'pending_enquiry_exists' => 'An open enquiry with same details already exists.',
        'received' => 'Your enquiry has been received. We will get back to you  as soon as possible.',
        'online' => 'Online',
    ],
    'enquiry' => [
        'enquiry' => 'Enquiry',
        'enquiries' => 'Enquiries',
        'module_title' => 'Manage all Enquiries',
        'module_description' => 'Enquiries are the first step towards admission of a student. Record all the enquiries and convert them to registration.',
        'online_enquiry_instruction_alert' => 'Please read the instruction carefully before proceeding.',
        'could_not_delete_if_closed' => 'You cannot delete enquiries that are closed.',
        'could_not_convert_to_registration' => 'Could not convert any enquiry to registration.',
        'could_not_modify_if_not_last_follow_up' => 'You cannot modify enquiry if it is not the last follow up.',
        'count' => 'Count',
        'convert_to_registration' => 'Convert to Registration',
        'successfully_converted_to_registration' => 'Successfully converted :attribute enquiries to registration.',
        'converted_to_registration' => 'Converted to Registration',
        'already_converted' => 'This enquiry has already been converted to registration.',
        'statuses' => [
            'open' => 'Open',
            'partially_closed' => 'Partially Closed',
            'missed' => 'Missed',
            'close' => 'Close',
        ],
        'props' => [
            'code_number' => 'Enquiry #',
            'date' => 'Date of Enquiry',
            'name' => 'Name',
            'email' => 'Email',
            'contact_number' => 'Contact Number',
            'nature' => 'Nature',
            'type' => 'Type',
            'source' => 'Source',
            'status' => 'Status',
            'stage' => 'Stage',
            'student_name' => 'Student Name',
            'assigned_to' => 'Assigned To',
            'remarks' => 'Remarks',
            'description' => 'Description',
        ],
        'follow_up' => [
            'follow_up' => 'Follow Up',
            'could_not_follow_up_before_enquiry_date' => 'You cannot follow up before the enquiry date.',
            'could_not_follow_up_before_previous_follow_up_date' => 'You cannot follow up before the previous follow up date.',
            'could_not_modify_if_not_last_follow_up' => 'You cannot modify follow up if it is not the last follow up.',
            'props' => [
                'follow_up_date' => 'Follow Up Date',
                'next_follow_up_date' => 'Next Follow Up Date',
                'status' => 'Status',
                'remarks' => 'Remarks',
            ],
        ],
        'stage' => [
            'stage' => 'Enquiry Stage',
            'stages' => 'Enquiry Stages',
            'module_title' => 'Manage all Enquiry Stages',
            'module_description' => 'Enquiry Stages are the stages of enquiries that are received by the institution.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'type' => [
            'type' => 'Enquiry Type',
            'types' => 'Enquiry Types',
            'module_title' => 'Manage all Enquiry Types',
            'module_description' => 'Enquiry Types are the type of enquiries that are received by the institution.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'source' => [
            'source' => 'Enquiry Source',
            'sources' => 'Enquiry Sources',
            'module_title' => 'Manage all Enquiry Sources',
            'module_description' => 'Enquiry Sources are the sources from which enquiries are received. For example: Website, Social Media, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'natures' => [
            'admission' => 'Admission',
            'other' => 'Other',
        ],
        'wizard' => [
            'first_step' => 'Basic',
            'second_step' => 'Photo',
            'third_step' => 'Contact',
            'fourth_step' => 'Guardian',
            'fifth_step' => 'Document',
            'sixth_step' => 'Qualification',
            'final_step' => 'Review',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Enquiry Number Prefix',
                'number_suffix' => 'Enquiry Number Suffix',
                'number_digit' => 'Enquiry Number Digit',
            ],
        ],
    ],
    'visitor_log' => [
        'visitor' => 'Visitor',
        'visitor_log' => 'Visitor Log',
        'visitor_logs' => 'Visitor Logs',
        'module_title' => 'Manage all Visitor Logs',
        'module_description' => 'Keep a record of visitors who visit the institution.',
        'pass' => 'Visitor Pass',
        'props' => [
            'code_number' => 'Log #',
            'purpose' => 'Purpose',
            'name' => 'Name',
            'company_name' => 'Company Name',
            'contact_number' => 'Contact Number',
            'type' => 'Type',
            'relation' => 'Relation',
            'count' => 'Visitor Count',
            'whom_to_meet' => 'Whom to Meet',
            'entry_at' => 'Entry at',
            'entry' => 'Entry',
            'exit_at' => 'Exit at',
            'exit' => 'Exit',
            'remarks' => 'Remarks',
        ],
        'types' => [
            'student' => 'Student',
            'guardian' => 'Guardian',
            'employee' => 'Employee',
            'other' => 'Other',
        ],
        'purpose' => [
            'purpose' => 'Visiting Purpose',
            'purposes' => 'Visiting Purposes',
            'module_title' => 'Manage all Visiting Purposes',
            'module_description' => 'Add purposes for visitors to visit the institution.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Visitor Log Number Prefix',
                'number_suffix' => 'Visitor Log Number Suffix',
                'number_digit' => 'Visitor Log Number Digit',
            ],
        ],
    ],
    'gate_pass' => [
        'gate_pass' => 'Gate Pass',
        'gate_passes' => 'Gate Passes',
        'module_title' => 'Manage all Gate Passes',
        'module_description' => 'Gate Passes are issued to students or employees to leave the institution.',
        'props' => [
            'code_number' => 'Gate Pass #',
            'datetime' => 'Date Time',
            'start_at' => 'Start at',
            'left_at' => 'Left at',
            'end_at' => 'End at',
            'return_at' => 'Return at',
            'to' => 'To',
            'requester' => 'Requester',
            'purpose' => 'Purpose',
            'status' => 'Status',
            'reason' => 'Reason',
            'remarks' => 'Remarks',
        ],
        'to' => [
            'student' => 'Student',
            'employee' => 'Employee',
        ],
        'statuses' => [
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
        ],
        'purpose' => [
            'purpose' => 'Gate Pass Purpose',
            'purposes' => 'Gate Pass Purposes',
            'module_title' => 'Manage all Gate Pass Purposes',
            'module_description' => 'Add purposes for gate passes issued to students or employees.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Gate Pass Number Prefix',
                'number_suffix' => 'Gate Pass Number Suffix',
                'number_digit' => 'Gate Pass Number Digit',
            ],
        ],
    ],
    'call_log' => [
        'call_log' => 'Call Log',
        'call_logs' => 'Call Logs',
        'module_title' => 'Manage all Call Logs',
        'module_description' => 'Keep a record of calls made/received by the institution.',
        'props' => [
            'type' => 'Type',
            'purpose' => 'Purpose',
            'name' => 'Name',
            'company_name' => 'Company Name',
            'datetime' => 'Date Time',
            'call_at' => 'Call at',
            'incoming_number' => 'Incoming Number',
            'outgoing_number' => 'Outgoing Number',
            'duration' => 'Duration',
            'conversation' => 'Conversation',
            'remarks' => 'Remarks',
        ],
        'types' => [
            'incoming' => 'Incoming',
            'outgoing' => 'Outgoing',
        ],
        'purpose' => [
            'purpose' => 'Calling Purpose',
            'purposes' => 'Calling Purposes',
            'module_title' => 'Manage all Calling Purposes',
            'module_description' => 'Add purposes for calls made/received by the institution.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
    ],
    'complaint' => [
        'complaint' => 'Complaint',
        'complaints' => 'Complaints',
        'module_title' => 'Manage all Complaints',
        'module_description' => 'Complaints are the issues/problems faced by the students or guardians.',
        'online' => 'Online',
        'assign' => 'Assign',
        'could_not_modify_if_not_last_log' => 'You cannot modify action if it is not the last record.',
        'statuses' => [
            'submitted' => 'Submitted',
            'in_progress' => 'In Progress',
            'rejected' => 'Rejected',
            'resolved' => 'Resolved',
            'cancelled' => 'Cancelled',
        ],
        'logs' => 'Logs',
        'props' => [
            'code_number' => 'Complaint #',
            'type' => 'Type',
            'subject' => 'Subject',
            'complainant' => 'Complainant',
            'name' => 'Name',
            'contact_number' => 'Contact Number',
            'address' => 'Address',
            'date' => 'Date',
            'time' => 'Time',
            'description' => 'Description',
            'action' => 'Action',
            'resolved_at' => 'Resolved At',
            'assigned_to' => 'Assigned To',
            'status' => 'Status',
            'comment' => 'Comment',
            'datetime' => 'Date Time',
            'remarks' => 'Remarks',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Complaint Number Prefix',
                'number_suffix' => 'Complaint Number Suffix',
                'number_digit' => 'Complaint Number Digit',
            ],
        ],
        'type' => [
            'type' => 'Complaint Type',
            'types' => 'Complaint Types',
            'module_title' => 'Manage all Complaint Types',
            'module_description' => 'Complaint Types are the types of complaints that are received by the institution. For example: Academic, Non-Academic, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
    ],
    'query' => [
        'query' => 'Query',
        'queries' => 'Queries',
        'module_title' => 'Manage all Queries',
        'module_description' => 'Queries are submitted by visitors via the website.',
        'statuses' => [
            'submitted' => 'Submitted',
            'in_progress' => 'In Progress',
            'resolved' => 'Resolved',
        ],
        'props' => [
            'code_number' => 'Query #',
            'name' => 'Name',
            'email' => 'Email',
            'phone' => 'Phone',
            'subject' => 'Subject',
            'message' => 'Message',
            'action' => 'Action',
            'status' => 'Status',
            'remarks' => 'Remarks',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Query Number Prefix',
                'number_suffix' => 'Query Number Suffix',
                'number_digit' => 'Query Number Digit',
            ],
        ],
    ],
];
