<?php

return [
    'inventory' => 'Inventory',
    'inventories' => 'Inventories',
    'module_title' => 'List all Inventories',
    'module_description' => 'Manage all Inventories',
    'transaction' => 'Transaction',
    'unit' => [
        'unit' => 'Unit',
        'units' => 'Units',
        'module_title' => 'List all Units',
        'module_description' => 'Manage all Units',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'stock_item_condition' => [
        'stock_item_condition' => 'Stock Item Condition',
        'stock_item_conditions' => 'Stock Item Conditions',
        'module_title' => 'List all Stock Item Conditions',
        'module_description' => 'Manage all Stock Item Conditions',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'vendor' => [
        'vendor' => 'Vendor',
        'vendors' => 'Vendors',
        'module_title' => 'List all Vendors',
        'module_description' => 'Manage all Vendors',
        'props' => [
            'name' => 'Name',
            'contact_number' => 'Contact Number',
            'email' => 'Email',
            'website' => 'Website',
            'tax_number' => 'Tax Number',
            'description' => 'Description',
            'balance' => 'Balance',
        ],
        'statement' => [
            'statement' => 'Vendor Statement',
            'module_title' => 'Listing Vendor Statement',
            'module_description' => 'Get all records of vendors for given period.',
        ],
    ],
    'place' => 'Place',
    'item' => 'Item',
    'props' => [
        'name' => 'Name',
        'description' => 'Description',
    ],
    'with_items' => 'With Items',
    'without_items' => 'Without Items',
    'incharge' => [
        'incharge' => 'Inventory Incharge',
        'incharges' => 'Inventory Incharges',
        'module_title' => 'List all Inventory Incharges',
        'module_description' => 'Manage all Inventory Incharges',
    ],
    'stock_category' => [
        'category' => 'Category',
        'stock_category' => 'Stock Category',
        'stock_categories' => 'Stock Categories',
        'module_title' => 'List all Stock Categories',
        'module_description' => 'Manage all Stock Categories',
        'could_not_change_inventory_after_transaction' => 'Could not change inventory after stock transaction.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'stock_item' => [
        'item' => 'Item',
        'stock_item' => 'Stock Item',
        'stock_items' => 'Stock Items',
        'module_title' => 'List all Stock Items',
        'module_description' => 'Manage all Stock Items',
        'duplicate_item' => 'Item already exists in this category',
        'could_not_change_inventory_after_transaction' => 'Could not change inventory after stock transaction.',
        'could_not_change_tracking_type' => 'Could not change tracking type.',
        'could_not_change_code' => 'Could not change code.',
        'opening_balance' => 'Opening Balance',
        'purchased_quantity' => 'Purchased Quantity',
        'returned_quantity' => 'Returned Quantity',
        'adjusted_quantity' => 'Adjusted Quantity',
        'current_balance' => 'Current Balance',
        'types' => [
            'consumable' => 'Consumable',
            'non_consumable' => 'Non Consumable',
        ],
        'tracking_types' => [
            'unique' => 'Unique',
            'bulk' => 'Bulk',
        ],
        'hold_statuses' => [
            'damaged' => 'Damaged',
            'lost' => 'Lost',
        ],
        'statuses' => [
            'hold' => 'Hold',
            'stock' => 'Stock',
        ],
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'type' => 'Type',
            'tracking_type' => 'Tracking Type',
            'unit' => 'Unit',
            'condition' => 'Condition',
            'description' => 'Description',
            'place' => 'Place',
            'price' => 'Price',
            'unit_price' => 'Unit Price',
            'invoice_date' => 'Invoice Date',
            'invoice_number' => 'Invoice Number',
            'amount' => 'Amount',
            'opening_quantity' => 'Opening Quantity',
            'quantity' => 'Quantity',
            'status' => 'Status',
            'start_number' => 'Start Number',
            'end_number' => 'End Number',
            'hsn' => 'HSN',
        ],
        'label' => 'Label',
        'label_per_page' => 'Label Per Page',
        'copy' => [
            'copy' => 'Copy',
            'copies' => 'Copies',
            'module_title' => 'List all Stock Item Copies',
            'module_description' => 'Manage all Stock Item Copies',
            'props' => [
                'code_number_short' => '#',
                'code_number' => 'Item Number',
                'status' => 'Status',
                'hold_status' => 'Hold Status',
            ],
            'statuses' => [
                'hold' => 'Hold',
                'stock' => 'Stock',
            ],
        ],
    ],
    'stock_purchase' => [
        'purchase' => 'Purchase',
        'stock_purchase' => 'Stock Purchase',
        'stock_purchases' => 'Stock Purchases',
        'module_title' => 'List all Stock Purchases',
        'module_description' => 'Manage all Stock Purchases',
        'could_not_delete_if_purchase_exists_after_this_date' => 'Could not delete if purchase exists after this date',
        'could_not_edit_place' => 'Could not edit place.',
        'could_not_change_quantity_for_unique_item' => 'Could not change quantity for unique item.',
        'could_not_alter_item_for_tracking_type_item' => 'Could not alter item for tracking type item.',
        'has_items_info' => 'Enable this option if you want to record items.',
        'props' => [
            'code_number' => 'Purchase #',
            'items' => 'Items',
            'date' => 'Date',
            'voucher_number' => 'Voucher Number',
            'place' => 'Place',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_price' => 'Unit Price',
            'has_items' => 'Record Items',
            'amount' => 'Amount',
            'total' => 'Total',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Stock Purchase Number Prefix',
                'number_suffix' => 'Stock Purchase Number Suffix',
                'number_digit' => 'Stock Purchase Number Digit',
            ],
        ],
    ],
    'stock_return' => [
        'return' => 'Return',
        'stock_return' => 'Stock Return',
        'stock_returns' => 'Stock Returns',
        'module_title' => 'List all Stock Returns',
        'module_description' => 'Manage all Stock Returns',
        'could_not_delete_if_return_exists_after_this_date' => 'Could not delete if return exists after this date',
        'could_not_edit_place' => 'Could not edit place.',
        'has_items_info' => 'Enable this option if you want to record items.',
        'props' => [
            'code_number' => 'Return #',
            'items' => 'Items',
            'date' => 'Date',
            'voucher_number' => 'Voucher Number',
            'place' => 'Place',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_price' => 'Unit Price',
            'has_items' => 'Record Items',
            'amount' => 'Amount',
            'total' => 'Total',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Stock Return Number Prefix',
                'number_suffix' => 'Stock Return Number Suffix',
                'number_digit' => 'Stock Return Number Digit',
            ],
        ],
    ],
    'stock_requisition' => [
        'requisition' => 'Requisition',
        'stock_requisition' => 'Stock Requisition',
        'stock_requisitions' => 'Stock Requisitions',
        'module_title' => 'List all Stock Requisitions',
        'module_description' => 'Manage all Stock Requisitions',
        'could_not_delete_if_requisition_exists_after_this_date' => 'Could not delete if requisition exists after this date',
        'could_not_edit_place' => 'Could not edit place.',
        'slip' => 'Requisition Slip',
        'props' => [
            'code_number' => 'Requisition #',
            'items' => 'Items',
            'date' => 'Date',
            'voucher_number' => 'Voucher Number',
            'place' => 'Place',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_price' => 'Unit Price',
            'requested_by' => 'Requested By',
            'message_to_vendor' => 'Message to Vendor',
            'amount' => 'Amount',
            'total' => 'Total',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Stock Requisition Number Prefix',
                'number_suffix' => 'Stock Requisition Number Suffix',
                'number_digit' => 'Stock Requisition Number Digit',
            ],
        ],
    ],
    'stock_transfer' => [
        'transfer' => 'Transfer',
        'stock_transfer' => 'Stock Transfer',
        'stock_transfers' => 'Stock Transfers',
        'module_title' => 'List all Stock Transfers',
        'module_description' => 'Manage all Stock Transfers',
        'could_not_delete_if_transfer_exists_after_this_date' => 'Could not delete if transfer exists after this date',
        'could_not_edit_from_to' => 'Could not edit from & to place.',
        'from_to_same' => 'From & to place cannot be same.',
        'props' => [
            'code_number' => 'Transfer #',
            'items' => 'Items',
            'date' => 'Date',
            'return_date' => 'Return Date',
            'from' => 'From',
            'to' => 'To',
            'place' => 'Place',
            'from_place' => 'From Place',
            'to_place' => 'To Place',
            'description' => 'Description',
            'quantity' => 'Quantity',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Stock Transfer Number Prefix',
                'number_suffix' => 'Stock Transfer Number Suffix',
                'number_digit' => 'Stock Transfer Number Digit',
            ],
        ],
    ],
    'stock_adjustment' => [
        'adjustment' => 'Adjustment',
        'stock_adjustment' => 'Stock Adjustment',
        'stock_adjustments' => 'Stock Adjustments',
        'module_title' => 'List all Stock Adjustments',
        'module_description' => 'Manage all Stock Adjustments',
        'could_not_delete_if_adjustment_exists_after_this_date' => 'Could not delete if adjustment exists after this date',
        'could_not_edit_place' => 'Could not edit place.',
        'negative_quantity_hint' => 'Use negative quantity for stock reduction.',
        'props' => [
            'code_number' => 'Adjustment #',
            'items' => 'Items',
            'date' => 'Date',
            'place' => 'Place',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'unit_price' => 'Unit Price',
        ],
        'config' => [
            'props' => [
                'number_prefix' => 'Stock Adjustment Number Prefix',
                'number_suffix' => 'Stock Adjustment Number Suffix',
                'number_digit' => 'Stock Adjustment Number Digit',
            ],
        ],
    ],
    'config' => [
        'config' => 'Config',
        'general' => 'General',
        'props' => [
            'enable_quantity_during_item_creation' => 'Enable Quantity During Item Creation',
        ],
    ],
    'report' => [
        'report' => 'Report',
        'reports' => 'Reports',
        'item_summary' => [
            'item_summary' => 'Item Summary Report',
            'module_title' => 'List all Item Summary',
            'module_description' => 'Manage all Item Summary',
        ],
    ],
];
