<?php

return [
    'finance' => 'Finance',
    'receipt_vs_payment' => 'Receipt vs Payment',
    'course_wise_summary' => 'Course Wise Summary',
    'concession_summary' => 'Concession Summary',
    'payment_failed' => 'Payment failed.',
    'payment_cancelled' => 'Your payment has been cancelled. Please use :attribute for future reference.',
    'payment_amount_mismatch' => 'Sorry! Your payment was failed because of amount mismatch.',
    'unsupported_currency' => 'Sorry! Your payment could not be processed because of unsupported currency.',
    'invalid_token' => 'Sorry! Your payment was failed because of invalid token.',
    'total_mismatch' => 'Sorry! The total amount does not match with input total amount.',
    'amount_mismatch' => 'Sorry! Your payment was failed because of amount mismatch. Please use :attribute for future reference.',
    'id_mismatch' => 'Sorry! Your payment was failed because of id mismatch. Please use :attribute for future reference.',
    'amount_refunded' => 'Sorry! Your payment was failed because the amount is refunded. Please use :attribute for future reference.',
    'pg_version_mismatch' => 'Sorry! Your payment was incomplete because of gateway version mismatch. Please use :attribute for future reference.',
    'could_not_update_payment_status' => 'Could not update payment status.',
    'no_response_received' => 'No transaction response received from the payment gateway. Please use :attribute for future reference.',
    'transaction_failed' => 'Sorry! Your payment was failed. Please use :attribute for future reference.',
    'payment_succeed' => 'Your payment of :amount is successful. Please use :attribute for future reference.',
    'online_receipt_info' => 'This is computer generated receipt. No signature required.',
    'day_closure' => [
        'day_closure' => 'Day Closure',
        'day_closures' => 'Day Closures',
        'module_title' => 'Listing all Day Closures',
        'module_description' => 'Get list of all account closures by cashier/accountant.',
        'already_marked' => 'You have already marked the day closure.',
        'could_not_make_payment_after_closure' => 'Could not make payment after marking day closure.',
        'collected_amount' => 'Collected Amount :amount for :date.',
        'total_mismatch_with_collected_amount' => 'Total :amount mismatch with collected amount :collected_amount.',
        'could_not_delete_previous_closure' => 'Could not delete previous closure, only last day closure can be deleted.',
        'statuses' => [
            'submitted' => 'Submitted',
            'approved' => 'Approved',
        ],
        'types' => [
            'auto' => 'Auto',
            'manual' => 'Manual',
        ],
        'props' => [
            'date' => 'Date',
            'count' => 'Count',
            'total' => 'Total',
            'system_generated' => 'System Generated',
            'status' => 'Status',
            'difference' => 'Difference',
            'denominations' => 'Denominations',
            'amount_mismatch' => 'Amount Mismatch',
            'remarks' => 'Remarks',
            'reason' => 'Reason for Mismatch',
        ],
    ],
    'fee' => [
        'fee' => 'Fee',
        'payable_amount' => 'Payable Amount',
        'total' => 'Total',
        'paid' => 'Paid',
        'concession' => 'Concession',
        'concession_amount' => 'Concession Amount',
        'concession_remarks' => 'Concession Remarks',
        'balance' => 'Balance',
        'due' => 'Due',
        'not_paid' => 'The fee is not yet paid.',
        'amount_gt_balance' => 'Amount :amount is greater than balance :balance.',
        'paid_gt_amount' => 'Paid :paid is greater than amount :amount for :head.',
        'paid_concession' => 'Could not update fee installment, concession is already paid.',
        'default_fee_heads' => [
            'late_fee' => 'Late Fee',
            'transport_fee' => 'Transport Fee',
            'additional_charge' => 'Additional Charge',
            'additional_discount' => 'Additional Discount',
        ],
        'default_custom_fee_types' => [
            'subject_wise_exam_fee' => 'Subject Wise Exam Fee',
            'exam_form_fee' => 'Exam Form Fee',
            'exam_form_late_fee' => 'Exam Form Late Fee',
            'library_charge' => 'Library Charge',
        ],
    ],
    'fee_group' => [
        'fee_group' => 'Fee Group',
        'fee_groups' => 'Fee Groups',
        'module_title' => 'List all Fee Group',
        'module_description' => 'Fee group is a collection of similar fee heads. For example, School Fee can have Admission Fee, Tuition Fee as fee heads.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'description' => 'Description',
        ],
    ],
    'fee_head' => [
        'fee_head' => 'Fee Head',
        'fee_heads' => 'Fee Heads',
        'module_title' => 'List all Fee Head',
        'module_description' => 'Heads under which the fee is collected. For example, Admission Fee, Tuition Fee, etc.',
        'could_not_modify_if_installment_exists' => 'Could not modify fee head, fee installment exists.',
        'custom_fee' => 'Custom Fee',
        'reserved_name' => 'Reserved name, please use different name.',
        'props' => [
            'name' => 'Name',
            'type' => 'Fee Type',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'components' => 'Components',
            'description' => 'Description',
        ],
    ],
    'fee_component' => [
        'fee_component' => 'Fee Component',
        'fee_components' => 'Fee Components',
        'module_title' => 'List all Fee Component',
        'module_description' => 'Components are the parts of fee head. For example, Book Fee may have TextBook Fee, Stationary Fee, etc.',
        'could_not_modify_if_installment_exists' => 'Could not modify fee component, fee installment exists.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'description' => 'Description',
        ],
    ],
    'fee_concession' => [
        'fee_concession' => 'Fee Concession',
        'fee_concessions' => 'Fee Concessions',
        'custom_concession' => 'Custom Concession',
        'apply_to_all_installments' => 'Apply to all Installments',
        'apply_to_all_installments_info' => 'If enabled, the concession will be applied to all installments of this fee group.',
        'no_concession' => 'No Concession',
        'module_title' => 'List all Fee Concession',
        'module_description' => 'Fee concession is a discount given to the student. For example, Sibling Concession, Staff Child Concession, etc.',
        'given_between' => 'Given Between',
        'secondary_concession' => 'Secondary Concession',
        'secondary_concession_info' => 'If enabled, the concession will be applied after applying primary concession.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'transport_type' => 'Transport Concession Type',
            'transport_value' => 'Transport Concession Value',
            'type' => 'Type',
            'amount' => 'Amount',
            'value' => 'Value',
            'percent' => 'Percent',
            'description' => 'Description',
        ],
        'type' => [
            'type' => 'Fee Concession Type',
            'types' => 'Fee Concession Types',
            'module_title' => 'List all Fee Concession Type',
            'module_description' => 'Manage all Fee Concession Type',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
    ],
    'fee_structure' => [
        'fee_structure' => 'Fee Structure',
        'fee_structures' => 'Fee Structures',
        'module_title' => 'List all Fee Structure',
        'module_description' => 'Fee structure are set of fee installments with due dates and amount with some constraints.',
        'installment' => 'Fee Installment',
        'installment_count' => 'Installment Count',
        'installment_number' => 'Fee Installment :attribute',
        'installments' => 'Fee Installments',
        'allocate' => 'Allocate Fee',
        'allocation' => 'Fee Allocation',
        'late_fee' => 'Late Fee',
        'component_already_exists' => 'Component already exists.',
        'component_amount_mismatch' => 'The sum of the components amount must be equal to the fee head amount.',
        'not_allocated' => 'Fee not allocated to the course or batch.',
        'duplicate_title_found' => 'Duplicate title found for :attribute.',
        'not_editable_as_fee_paid' => 'Fee structure is not editable as some fee installments are paid.',
        'fee_already_allocated' => ':attribute has already fee allocated.',
        'could_not_edit_installment' => 'Could not edit fee installment, it is paid :attribute time(s).',
        'could_not_edit_assigned_installment' => 'Could not edit fee installment, it is assigned to :attribute student(s).',
        'could_not_delete_installment' => 'Could not delete fee installment, it is paid :attribute time(s).',
        'could_not_delete_allocation_if_allocated' => 'Could not delete fee allocation, fee is already allocated to the students.',
        'frequencies' => [
            'one_time' => 'One Time',
            'daily' => 'Daily',
            'weekly' => 'Weekly',
            'fortnightly' => 'Fortnightly',
            'monthly' => 'Monthly',
            'bi_monthly' => 'Bi Monthly',
            'quarterly' => 'Quarterly',
            'bi_annually' => 'Bi Annually',
            'annually' => 'Annually',
        ],
        'due_on' => 'Due On :attribute',
        'overdue_by' => 'Overdue by :attribute days',
        'props' => [
            'name' => 'Name',
            'amount' => 'Amount',
            'title' => 'Title',
            'description' => 'Description',
            'is_optional' => 'Is Optional',
            'applicable_to' => 'Applicable To',
            'applicable_to_gender' => 'Applicable To Gender',
            'new_student' => 'New Student',
            'old_student' => 'Old Student',
            'all_student' => 'All Student',
            'male_student' => 'Male Student',
            'female_student' => 'Female Student',
            'applicable' => 'Applicable',
            'is_mandatory' => 'Is Mandatory',
            'due_date' => 'Due Date',
            'optional' => 'Optional',
            'mandatory' => 'Mandatory',
            'has_transport_fee' => 'Has Transport Fee',
            'late_fee' => 'Late Fee',
            'has_late_fee' => 'Has Late Fee',
            'late_fee_value' => 'Late Fee Charge',
            'late_fee_frequency' => 'Late Fee Frequency',
            'late_fee_type' => 'Type',
            'late_fee_type_amount' => 'Amount',
            'late_fee_type_percent' => 'Percent',
        ],
    ],
    'late_fee_frequencies' => [
        'one_time' => 'One Time',
        'daily' => 'Daily',
        'weekly' => 'Weekly',
        'fortnightly' => 'Fortnightly',
        'monthly' => 'Monthly',
        'bi_monthly' => 'Bi-monthly',
        'quarterly' => 'Quarterly',
        'bi_annually' => 'Bi-annually',
        'annually' => 'Annually',
    ],
    'payment_statuses' => [
        'not_applicable' => 'Not Applicable',
        'paid' => 'Paid',
        'unpaid' => 'Unpaid',
        'partial' => 'Partial',
        'partially_paid' => 'Partially Paid',
    ],
    'tax' => [
        'tax' => 'Tax',
        'taxes' => 'Taxes',
        'module_title' => 'List all Tax',
        'module_description' => 'Taxes are the additional charges applied to the transactions.',
        'has_components_info' => 'If enabled, the taxes can have multiple sub components like GST can have CGST, SGST etc.',
        'components_rate_mismatch' => 'The sum of the components rate must be equal to the tax rate.',
        'types' => [
            'inclusive' => 'Inclusive',
            'exclusive' => 'Exclusive',
        ],
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'rate' => 'Rate',
            'type' => 'Type',
            'hsn_code' => 'HSN Code',
            'components' => 'Components',
            'description' => 'Description',
        ],
    ],
    'bank_name' => [
        'bank_name' => 'Bank Name',
        'bank_names' => 'Bank Names',
        'module_title' => 'List all Bank Name',
        'module_description' => 'Manage all Bank Name',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'card_provider' => [
        'card_provider' => 'Card Provider',
        'card_providers' => 'Card Providers',
        'module_title' => 'List all Card Provider',
        'module_description' => 'Manage all Card Provider',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'ledger' => [
        'ledger' => 'Ledger',
        'ledgers' => 'Ledgers',
        'module_title' => 'List all Ledgers',
        'module_description' => 'Ledgers are the accounts under which the transactions are recorded.',
        'primary_ledger' => 'Primary Ledger',
        'secondary_ledger' => 'Secondary Ledger',
        'groups' => [
            'cash' => 'Cash',
            'bank_account' => 'Bank Account',
            'overdraft_account' => 'Overdraft Account',
            'sundry_debtor' => 'Sundry Debtor',
            'sundry_creditor' => 'Sundry Creditor',
            'direct_expense' => 'Direct Expense',
            'indirect_expense' => 'Indirect Expense',
            'direct_income' => 'Direct Income',
            'indirect_income' => 'Indirect Income',
        ],
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'code' => 'Code',
            'description' => 'Description',
            'contact' => 'Contact',
            'account' => 'Account',
            'contact_number' => 'Contact Number',
            'email' => 'Email',
            'code_prefix' => 'Prefix',
            'code_digit' => 'Digit',
            'code_suffix' => 'Suffix',
            'code_format' => 'Code Format',
            'opening_balance' => 'Opening Balance',
            'current_balance' => 'Current Balance',
            'net_balance' => 'Net Balance',
            'balance' => 'Balance :attribute',
        ],
    ],
    'ledger_type' => [
        'ledger_type' => 'Ledger Type',
        'ledger_types' => 'Ledger Types',
        'module_title' => 'List all Ledger Types',
        'module_description' => 'Ledger types are the types of ledgers. For example, Cash, Bank Account, Sundry Debtor, Sundry Creditor, etc.',
        'default' => 'Default',
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'code' => 'Code',
            'parent' => 'Parent',
            'description' => 'Description',
        ],
    ],
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'info' => 'Account Information',
        'number_info' => 'Voucher Number Information',
        'props' => [
            'primary' => 'Primary',
            'name' => 'Account Name',
            'alias' => 'Alias',
            'number' => 'Account number',
            'bank_name' => 'Bank Name',
            'branch_name' => 'Branch Name',
            'branch_address' => 'Branch Address',
            'branch_code' => 'Branch Code',
        ],
    ],
    'bank_transfer' => [
        'bank_transfer' => 'Bank Transfer',
        'bank_transfers' => 'Bank Transfers',
        'module_title' => 'List all Bank Transfers',
        'module_description' => 'Bank transfers are the records of bank transfers made by students/guardians or other person. For example, Fee paid directly to the school bank account.',
        'props' => [
            'number_format' => 'Number Format',
            'number' => 'Number',
            'code_number' => 'Code Number',
            'date' => 'Date',
            'amount' => 'Amount',
            'currency' => 'Currency',
            'status' => 'Status',
            'remarks' => 'Remarks',
            'comment' => 'Comment',
        ],
        'statuses' => [
            'pending' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
        ],
    ],
    'receipt' => [
        'receipt' => 'Receipt',
        'module_title' => 'List all Receipts',
        'module_description' => 'Receipts are the payment collected for different purposes. For example, Donation, Canteen Payment, etc.',
        'props' => [
            'payee' => 'Payee',
        ],
    ],
    'transaction' => [
        'transaction' => 'Transaction',
        'transactions' => 'Transactions',
        'module_title' => 'List all Transactions',
        'module_description' => 'Transactions are the records of financial transactions. For example, Payment, Receipt, etc.',
        'detail' => 'Transaction Detail',
        'pending_clearance' => 'Pending Clearance',
        'voucher' => 'Voucher',
        'clearing_date_before_transaction_date' => 'Clearing date cannot be before transaction date.',
        'payment_label' => 'Amount Paid For',
        'receipt_label' => 'Amount Received For',
        'transfer_label' => 'Amount Transferred For',
        'props' => [
            'type' => 'Type',
            'head' => 'Head',
            'status' => 'Status',
            'code_number' => 'Voucher Number',
            'code_number_short' => 'Voucher #',
            'amount' => 'Amount',
            'date' => 'Date',
            'payee' => 'Payee',
            'payee_detail' => 'Name of entity receiving payment',
            'payer' => 'Payer',
            'category' => 'Category',
            'remarks' => 'Remarks',
            'description' => 'Description',
            'instrument_number' => 'Instrument Number',
            'instrument_date' => 'Instrument Date',
            'clearing_date' => 'Clearing Date',
            'bank_detail' => 'Bank Detail',
            'branch_detail' => 'Branch Detail',
            'reference_number' => 'Reference Number',
            'card_provider' => 'Card Provider',
            'payment_rejected' => 'Payment Rejected',
            'rejected_date' => 'Date Rejected',
            'rejection_charge' => 'Rejection Charge',
            'rejection_remarks' => 'Rejection Remarks',
            'cancellation_remarks' => 'Cancellation Remarks',
            'invoice_number' => 'Invoice Number',
            'invoice_date' => 'Invoice Date',
            'error_code' => 'Error Code',
            'mode' => 'Mode',
            'details' => 'Details',
            'force_cancel' => 'Force Cancel',
        ],
        'category' => [
            'category' => 'Transaction Category',
            'categories' => 'Transaction Categories',
            'category_short' => 'Category',
            'module_title' => 'List all Transaction Categories',
            'module_description' => 'Categorize transactions for better reporting and analysis. For example: stationery, transport, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'config' => [
            'config' => 'Config',
            'info' => 'Transaction Config',
            'number_variable_info' => 'You can use :attribute placeholders.',
            'types' => [
                'round_before_subtraction' => 'Round Before Subtraction',
                'round_after_subtraction' => 'Round After Subtraction',
            ],
            'concession_round_off_type_info' => 'Round off before subtraction will round off the concession amount before subtracting it from the fee amount. Round off after subtraction will round off the concession amount after subtracting it from the fee amount.',
            'currency_denominations_info' => 'Define all the currency denominations for transactions in comma separated values.',
            'props' => [
                'guest_payment' => 'Enable Guest Payment',
                'round_off_fee_concession' => 'Round Off Fee Concession',
                'concession_round_off_type' => 'Concession Round Off Type',
                'voucher_number_type' => 'Voucher Number Type',
                'payment_number' => 'Voucher Number',
                'payment_number_prefix' => 'Payment Voucher Number Prefix',
                'payment_number_suffix' => 'Payment Voucher Number Suffix',
                'payment_number_digit' => 'Payment Voucher Number Digit',
                'receipt_number' => 'Voucher Number',
                'receipt_number_prefix' => 'Receipt Voucher Number Prefix',
                'receipt_number_suffix' => 'Receipt Voucher Number Suffix',
                'receipt_number_digit' => 'Receipt Voucher Number Digit',
                'transfer_number' => 'Voucher Number',
                'transfer_number_prefix' => 'Transfer Voucher Number Prefix',
                'transfer_number_suffix' => 'Transfer Voucher Number Suffix',
                'transfer_number_digit' => 'Transfer Voucher Number Digit',
                'bank_transfer_number' => 'Voucher Number',
                'bank_transfer_number_prefix' => 'Bank Transfer Voucher Number Prefix',
                'bank_transfer_number_suffix' => 'Bank Transfer Voucher Number Suffix',
                'bank_transfer_number_digit' => 'Bank Transfer Voucher Number Digit',
                'online_transaction_number' => 'Online Voucher Number',
                'online_number_prefix' => 'Online Voucher Number Prefix',
                'online_number_suffix' => 'Online Voucher Number Suffix',
                'online_number_digit' => 'Online Voucher Number Digit',
                'currency_denominations' => 'Currency Denominations',
                'manual_receipt_number' => 'Manual Receipt Number',
            ],
        ],
        'types' => [
            'payment' => 'Payment',
            'receipt' => 'Receipt',
            'transfer' => 'Account Transfer',
        ],
        'heads' => [
            'registration_fee' => 'Registration Fee',
            'student_fee' => 'Student Fee',
            'fee_refund' => 'Fee Refund',
        ],
    ],
    'transaction_statuses' => [
        'pending' => 'Pending',
        'failed' => 'Failed',
        'cancelled' => 'Cancelled',
        'rejected' => 'Rejected',
        'succeed' => 'Succeed',
    ],
    'payment' => [
        'payment' => 'Payment',
        'online' => 'Online Payment',
        'could_not_cancel_online_payment' => 'Could not cancel online payment.',
        'already_cancelled' => 'Payment is already cancelled.',
        'already_rejected' => 'Payment is already rejected.',
    ],
    'payment_method' => [
        'payment_method' => 'Payment Method',
        'payment_methods' => 'Payment Methods',
        'online_payment_method' => 'Online Payment Method',
        'module_title' => 'List all Payment Methods',
        'module_description' => 'Payment methods are the ways to make the payment. For example, Cash, Cheque, Bank Transfer, etc.',
        'detail' => 'Payment Method Detail',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'description' => 'Description',
            'is_payment_gateway' => 'Is Payment Gateway',
            'payment_gateway_name' => 'Payment Gateway Name',
            'has_instrument_number' => 'Has Instrument Number',
            'has_instrument_date' => 'Has Instrument Date',
            'has_clearing_date' => 'Has Clearing Date',
            'has_bank_detail' => 'Has Bank Detail',
            'has_branch_detail' => 'Has Branch Detail',
            'has_reference_number' => 'Has Reference Number',
            'has_card_provider' => 'Has Card Provider',
        ],
    ],
    'report' => [
        'report' => 'Report',
        'reports' => 'Reports',
        'detailed_fee_payment' => 'Detailed Fee Payment Report',
        'day_book' => [
            'day_book' => 'Day Book Report',
            'module_title' => 'List all Day Book',
            'module_description' => 'Manage all Day Book',
        ],
        'fee_summary' => [
            'fee_summary' => 'Fee Summary Report',
            'head_wise_detail' => 'Head Wise Detail',
            'module_title' => 'List all Fee Summary',
            'module_description' => 'Manage all Fee Summary',
        ],
        'fee_concession' => [
            'fee_concession' => 'Fee Concession Report',
            'module_title' => 'List all Fee Concession',
            'module_description' => 'Manage all Fee Concession',
        ],
        'fee_concession_summary' => [
            'fee_concession_summary' => 'Fee Concession Summary Report',
            'module_title' => 'List all Fee Concession Summary',
            'module_description' => 'Manage all Fee Concession Summary',
        ],
        'fee_due' => [
            'fee_due' => 'Fee Due Report',
            'module_title' => 'List all Fee Due',
            'module_description' => 'Manage all Fee Due',
            'props' => [
                'due_on' => 'Due On',
                'overdue_by' => 'Overdue by',
            ],
        ],
        'installment_wise_fee_due' => [
            'installment_wise_fee_due' => 'Installment wise Fee Due Report',
            'module_title' => 'List all Installment wise Fee Due',
            'module_description' => 'Manage all Installment wise Fee Due',
            'props' => [
                'due_on' => 'Due On',
                'overdue_by' => 'Overdue by',
            ],
        ],
        'fee_head' => [
            'fee_head' => 'Fee Head Report',
            'module_title' => 'List all Fee Head',
            'module_description' => 'Manage all Fee Head',
            'select_fee_head' => 'Please select fee head to get report.',
            'props' => [],
        ],
        'fee_payment' => [
            'fee_payment' => 'Fee Payment Report',
            'module_title' => 'List all Fee Payment',
            'module_description' => 'Manage all Fee Payment',
            'props' => [],
        ],
        'online_fee_payment' => [
            'online_fee_payment' => 'Online Fee Payment Report',
            'module_title' => 'List all Fee Online Payment',
            'module_description' => 'Manage all Fee Online Payment',
            'props' => [],
        ],
        'head_wise_fee_payment' => [
            'head_wise_fee_payment' => 'Head wise Fee Payment Report',
            'module_title' => 'List all Head wise Fee Payment',
            'module_description' => 'Manage all Head wise Fee Payment',
            'props' => [],
        ],
        'payment_method_wise_summary' => [
            'payment_method_wise_summary' => 'Payment Method wise Summary Report',
        ],
        'payment_method_wise_user_collection' => [
            'payment_method_wise_user_collection' => 'Payment Method wise User Collection Report',
        ],
        'payment_method_wise_fee_payment' => [
            'payment_method_wise_fee_payment' => 'Payment Method wise Fee Payment Summary Report',
            'module_title' => 'List all Payment Method wise Fee Payment Summary',
            'module_description' => 'Manage all Payment Method wise Fee Payment Summary',
            'props' => [],
        ],
        'payment_method_wise_fee_payment_detail' => [
            'payment_method_wise_fee_payment_detail' => 'Payment Method wise Fee Payment Detail Report',
            'module_title' => 'List all Payment Method wise Fee Payment Detail',
            'module_description' => 'Manage all Payment Method wise Fee Payment Detail',
            'props' => [],
        ],
        'bank_transfer' => [
            'bank_transfer' => 'Bank Transfer Report',
            'module_title' => 'List all Bank Transfer',
            'module_description' => 'Manage all Bank Transfer',
            'props' => [],
        ],
        'fee_refund' => [
            'fee_refund' => 'Fee Refund Report',
            'module_title' => 'List all Fee Refund',
            'module_description' => 'Manage all Fee Refund',
            'props' => [],
        ],
    ],
    'config' => [
        'config' => 'Config',
        'info' => 'Finance Config',
        'general' => 'General Config',
        'payment_gateway' => 'Payment Gateway',
        'props' => [
            'enable_payment_gateway' => 'Enable :attribute',
            'payment_gateway_mode' => ':attribute Mode',
            'payment_gateway_version' => ':attribute Version',
            'payment_gateway_merchant' => ':attribute Merchant',
            'payment_gateway_client' => ':attribute Client',
            'payment_gateway_secret' => ':attribute Secret',
            'payment_gateway_signature' => ':attribute Signature',
            'payment_gateway_notification' => ':attribute Notification Key',
            'pg_account' => 'Payment Gateway Account',
            'pg_account_info' => 'Payment Gateway Account if you are collecting fee in different accounts',
            'bank_code1' => 'Bank Code 1',
            'bank_code1_label' => 'Bank Code 1 Label',
            'bank_code2' => 'Bank Code 2',
            'bank_code2_label' => 'Bank Code 2 Label',
            'bank_code3' => 'Bank Code 3',
            'bank_code3_label' => 'Bank Code 3 Label',
        ],
    ],
];
