<?php

return [
    'exam' => 'Exam',
    'exams' => 'Exams',
    'module_title' => 'List all Exams',
    'module_description' => 'Manage all Exams',
    'exam_report' => 'Exam Report',
    'incharge' => 'Exam Incharge',
    'total' => 'Total',
    'grand_total' => 'Grand Total',
    'total_short' => 'T',
    'overall_total_short' => 'O',
    'percent' => 'Percent',
    'percentage' => 'Percentage',
    'percentage_short' => '%',
    'assessment_short' => 'Assessment',
    'grade_short' => 'G',
    'absent_short' => 'Ab',
    's_no' => 'SNo',
    'cgpa' => 'CGPA',
    'gpa' => 'AGPA',
    'position' => 'Position',
    'rank' => 'Rank',
    'result_date' => 'Date of Result',
    'scholastic_area' => 'Scholastic Area',
    'co_scholastic_area' => 'Co-Scholastic Area',
    'grading_subject' => 'Grading Subject',
    'result_grade' => 'Grade',
    'highest_mark' => 'Highest Mark',
    'average_mark' => 'Average Mark',
    'lowest_mark' => 'Lowest Mark',
    'highest_grade' => 'Highest Grade',
    'total_absent' => 'Total Absent',
    'could_not_group_itself' => 'Could not group itself.',
    'could_not_find_all_exams' => 'Could not find all exams.',
    'filter_top_x_marks_max_limit' => 'Filter top X marks cannot be greater than :count.',
    'props' => [
        'name' => 'Name',
        'code' => 'Code',
        'display_name' => 'Display Name',
        'position' => 'Position',
        'weightage' => 'Weightage',
        'group_exams' => 'Group With Exam',
        'filter_top_x_marks' => 'Filter Top X Marks',
        'description' => 'Description',
    ],
    'config' => [
        'config' => 'Config',
        'props' => [
            'marksheet_format' => 'Marksheet Format',
            'enable_auto_lock_marks' => 'Auto Lock Marks',
            'auto_lock_marks_period' => 'Auto Lock Marks Period (In Days)',
            'unlock_temporarily_period' => 'Unlock Temporarily Period (In Minutes)',
        ],
    ],
    'report_types' => [
        'mark_based' => 'Mark Based',
        'credit_based' => 'Credit Based',
    ],
    'result' => 'Result',
    'results' => [
        'pass' => 'Pass',
        'fail' => 'Fail',
        'reassessment' => 'Need Reassessment',
    ],
    'term' => [
        'term' => 'Exam Term',
        'terms' => 'Exam Terms',
        'module_title' => 'List all Exam Terms',
        'module_description' => 'Manage all Exam Terms',
        'props' => [
            'name' => 'Name',
            'display_name' => 'Display Name',
            'position' => 'Position',
            'description' => 'Description',
        ],
    ],
    'grade' => [
        'grade' => 'Exam Grade',
        'grades' => 'Exam Grades',
        'module_title' => 'List all Exam Grades',
        'module_description' => 'Manage all Exam Grades',
        'props' => [
            'name' => 'Name',
            'records' => 'Records',
            'code' => 'Code',
            'min_score' => 'Min Score',
            'max_score' => 'Max Score',
            'value' => 'Value',
            'point' => 'Grade Point',
            'credit_point' => 'Credit Point',
            'label' => 'Label',
            'fail_grade' => 'Fail Grade',
            'description' => 'Description',
        ],
    ],
    'online_exam' => [
        'online_exam' => 'Online Exam',
        'online_exams' => 'Online Exams',
        'module_title' => 'List all Online Exams',
        'module_description' => 'Manage all Online Exams',
        'already_published' => 'Online exam is already published.',
        'already_unpublished' => 'Online exam is not yet published.',
        'already_cancelled' => 'Online exam is already cancelled.',
        'could_not_update_status_if_date_time_passed_start_date_time' => 'Could not update status if current date and time is passed exam start date and time.',
        'could_not_publish_without_questions' => 'Could not publish online exam without questions.',
        'start_submission' => 'Start Submission',
        'finish_submission_info' => 'You have answered all the questions. Please click on the button below to finish the submission. No changes can be made after submission.',
        'could_not_update_status_with_submissions' => 'Could not update status with submissions.',
        'already_result_published' => 'Online exam result is already published.',
        'could_not_publish_result_without_completing_exam' => 'Could not publish result without completing exam.',
        'negative_mark_not_allowed' => 'Negative marking is not allowed.',
        'evaluate' => 'Evaluate',
        'obtained_mark' => 'Obtained Mark',
        'comment' => 'Comment',
        'finish_submission' => 'Finish Submission',
        'current_time' => 'Current Time',
        'remaining_time' => ':attribute minutes remaining',
        'submit' => 'Submit',
        'upcoming' => 'Upcoming',
        'starting_in' => 'Starting in :attribute minutes',
        'live' => 'Live',
        'completed' => 'Completed',
        'result' => 'Result',
        'end_date_info' => 'Leave blank if end date is same as date.',
        'types' => [
            'mcq' => 'MCQ',
            'mixed' => 'Mixed',
        ],
        'question_types' => [
            'mcq' => 'MCQ',
            'single_line_question' => 'Single Line Question',
            'multi_line_question' => 'Multi Line Question',
            'file_upload' => 'File Upload',
        ],
        'props' => [
            'title' => 'Title',
            'date' => 'Date',
            'time' => 'Time',
            'start_time' => 'Start Time',
            'end_date' => 'End Date',
            'end_time' => 'End Time',
            'type' => 'Type',
            'pass_percentage' => 'Pass Percentage',
            'has_negative_marking' => 'Has Negative Marking',
            'negative_mark_percent_per_question' => 'Negative Mark Percent Per Question',
            'period' => 'Period',
            'duration' => 'Duration',
            'question' => 'Question',
            'answer' => 'Answer',
            'correct_answer' => 'Correct Answer',
            'options' => 'Options',
            'instructions' => 'Instructions',
            'description' => 'Description',
        ],
        'question' => [
            'question' => 'Question',
            'questions' => 'Questions',
            'module_title' => 'List all Online Exam Questions',
            'module_description' => 'Manage all Online Exam Questions',
            'props' => [
                'type' => 'Type',
                'title' => 'Title',
                'header' => 'Header',
                'option' => 'Option',
                'correct_answer' => 'Correct Answer',
                'mark' => 'Mark',
                'description' => 'Description',
            ],
        ],
        'submission' => [
            'submission' => 'Submission',
            'submissions' => 'Submissions',
            'module_title' => 'List all Online Exam Submissions',
            'module_description' => 'Manage all Online Exam Submissions',
            'props' => [
                'started_at' => 'Started At',
                'submitted_at' => 'Submitted At',
                'evaluated_at' => 'Evaluated At',
                'obtained_mark' => 'Obtained Mark',
            ],
        ],
    ],
    'assessment' => [
        'assessment' => 'Exam Assessment',
        'assessments' => 'Exam Assessments',
        'module_title' => 'List all Exam Assessments',
        'module_description' => 'Manage all Exam Assessments',
        'could_not_change_code_after_mark_recorded' => 'Could not change code after mark recorded.',
        'props' => [
            'name' => 'Name',
            'type' => 'Assessment Type',
            'code' => 'Code',
            'mark' => 'Mark',
            'marks' => 'Marks',
            'max_mark' => 'Max Mark',
            'passing_mark' => 'Passing Mark',
            'description' => 'Description',
        ],
    ],
    'observation' => [
        'observation' => 'Observation Parameter',
        'observations' => 'Observation Parameters',
        'module_title' => 'List all Observation Parameters',
        'module_description' => 'Manage all Observation Parameters',
        'props' => [
            'name' => 'Name',
            'parameter' => 'Observation Parameter',
            'code' => 'Code',
            'max_mark' => 'Max Mark',
            'description' => 'Description',
        ],
    ],
    'competency' => [
        'competency' => 'Competency Parameter',
        'competencies' => 'Competency Parameters',
        'module_title' => 'List all Competency Parameters',
        'module_description' => 'Manage all Competency Parameters and their indicators',
        'evaluation' => 'Competency Evaluation',
        'props' => [
            'name' => 'Name',
            'domain' => 'Domain',
            'indicator' => 'Indicator',
            'code' => 'Code',
            'description' => 'Description',
            'template' => 'Template',
        ],
    ],
    'schedule' => [
        'schedule' => 'Exam Schedule',
        'schedules' => 'Exam Schedules',
        'module_title' => 'List all Exam Schedules',
        'module_description' => 'Manage all Exam Schedules',
        'could_not_find_record' => 'Could not find exam for this subject.',
        'record_has_no_exam' => 'This subject is marked as no exam subject.',
        'copy_to_course' => 'Copy to Course',
        'could_not_find_result' => 'Could not find result for this exam.',
        'could_not_alter_mark_for_expired_period' => 'Could not alter mark for this exam as period has expired.',
        'auto_lock_marks_period_info' => 'You can update marks till :attribute. Marks will be locked after this date.',
        'cannot_alter_after_marksheet_published' => 'Cannot alter schedule after marksheet is published.',
        'cannot_alter_after_marksheet_processed' => 'Cannot alter schedule after marksheet is processed.',
        'alter_schedule_mark_recorded_info' => 'You have already started recording marks for this schedule. You cannot change exam, batch, grade, assessment or observation.',
        'marks_lt_obtained_mark' => 'Max mark cannot be less than obtained mark :attribute.',
        'competency_evaluation_not_configured_for_this_schedule' => 'Competency evaluation is not configured for this schedule.',
        'last_exam_date_after_record_dates' => 'Last exam date must be after all exam record dates.',
        'mark_locked' => 'Mark Locked',
        'form' => 'Exam Form',
        'reassessment' => 'Reassessment',
        'marksheet_statuses' => [
            'processed' => 'Processed',
            'pending' => 'Pending',
        ],
        'marksheet_processed_info' => 'Marksheet has been processed. Any changes in marks will need to process again.',
        'attempt_number' => ':attribute Attempt',
        'attempts' => [
            'first' => 'First',
            'second' => 'Second',
            'third' => 'Third',
            'fourth' => 'Fourth',
            'fifth' => 'Fifth',
        ],
        'props' => [
            'date' => 'Date',
            'period' => 'Period',
            'max_mark' => 'Max Mark',
            'marks' => 'Marks',
            'applicable' => 'Applicable',
            'last_exam_date' => 'Last Exam Date',
            'start_time' => 'Start Time',
            'duration' => 'Duration',
            'end_time' => 'End Time',
            'not_applicable' => 'Not Applicable',
            'grading' => 'Grading',
            'attempt' => 'Attempt',
            'has_grading' => 'Has Grading',
            'description' => 'Description',
        ],
        'config' => [
            'config' => 'Config',
        ],
    ],
    'form' => [
        'form' => 'Exam Form',
        'module_title' => 'List all Exam Forms',
        'module_description' => 'Manage all Exam Forms',
        'not_eligible_to_submit' => 'You are not eligible to submit exam form.',
        'fee_balance' => 'Could not submit form due to fee balance of :attribute.',
        'expired_info' => 'This form cannot be submitted as it is expired.',
        'last_date_expired' => 'Could not submit form due to last date expired.',
        'confirmed' => 'Form has been confirmed and waiting for submission.',
        'submitted' => 'Form has been submitted and waiting for approval.',
        'already_submitted' => 'Form has already been submitted.',
        'confirmed_info' => 'Form has been confirmed at :datetime and waiting for submission.',
        'submitted_info' => 'Form has been submitted at :datetime and waiting for approval.',
        'approved_info' => 'Form has been approved at :datetime.',
        'fee_info' => 'Total exam fee payable is :attribute.',
        'fee_confirmation' => 'I have checked all the subjects and fee and confirm that they are correct.',
        'disclaimer' => 'I have checked all the details and confirm that they are correct. Any changes after submission will not be entertained.',
        'props' => [
            'fee' => 'Exam Form Fee',
            'late_fee' => 'Late Fee',
            'last_date' => 'Last Date',
            'submitted_at' => 'Submitted At',
            'approved_at' => 'Approved At',
        ],
    ],
    'mark' => 'Exam Mark',
    'observation_mark' => 'Observation Mark',
    'max_mark' => 'Max Mark',
    'max_mark_short' => 'MM',
    'total_marks' => 'Total Marks',
    'obtained_marks' => 'Obtained Marks',
    'obtained_mark' => 'Obtained Mark',
    'obtained_mark_short' => 'OB',
    'comment' => 'Comment',
    'incharge_comment' => 'Incharge Comment',
    'result' => 'Result',
    'record' => 'Record Mark',
    'mark_recorded' => 'Mark Recorded',
    'could_not_record_observation_mark_without_observation_parameter' => 'Could not find observation parameter for this exam.',
    'marks_record_permission_denied' => 'You do not have permission to record marks for this exam.',
    'marksheet' => [
        'type' => 'Type',
        'cumulative' => 'Cumulative',
        'term_wise' => 'Term Wise',
        'exam_wise' => 'Exam Wise',
        'total_credit' => 'Total Credit',
        'obtained_credit' => 'Obtained Credit',
        'exam_wise_credit_based' => 'Exam Wise (Credit Based)',
        'exam_wise_default' => 'Exam Wise (Default)',
        'marksheet' => 'Marksheet',
        'published' => 'Marksheet Published',
        'processed' => 'Marksheet Processed',
        'template' => 'Template',
        'cumulative_assessment' => 'Cumulative Assessment',
        'not_generated' => 'Marksheet is not yet generated.',
        'not_published' => 'Marksheet is not yet published.',
        'course_wise' => 'Course Wise',
        'show_summary_report' => 'Show Summary Report',
        'show_overall_total' => 'Show Overall Total',
        'show_overall_grade' => 'Show Overall Grade',
        'sort_summary_report_by_rank' => 'Sort Summary Report by Rank',
    ],
    'admit_card' => [
        'admit_card' => 'Admit Card',
    ],
    'report' => [
        'report' => 'Report',
        'reports' => 'Reports',
        'course_wise' => 'Course Wise',
        'mark_summary' => [
            'mark_summary' => 'Mark Summary Report',
            'module_title' => 'Get Mark Summary Report',
            'module_description' => 'Summarize subject wise marks for all students.',
        ],
        'exam_summary' => [
            'exam_summary' => 'Exam Summary Report',
            'module_title' => 'Get Exam Summary Report',
            'module_description' => 'Summary report for all students.',
        ],
    ],
];
