<?php

return [
    'employee' => 'Employee',
    'employees' => 'Employees',
    'signature' => 'Signature',
    'module_title' => 'Manage all employees',
    'module_quote' => 'Take care of your Employees & they will take care of your Business.',
    'module_description' => 'Employees are your asset. You can manage all your employee records here.',
    'exists' => 'Duplicate employee details found.',
    'permission_denied' => 'You don\'t have permission to access this employee records.',
    'no_employee_associated' => 'No employee record associated with this user.',
    'joining_date_less_than_leaving_date' => 'Employee joining date cannot be less than :attribute.',
    'already_exited' => 'Employee has already left on :attribute.',
    'user_not_found' => 'Could not find user associated with this employee.',
    'email_required_to_create_account' => 'Email is required to create account.',
    'could_not_select_team' => 'Could not select team.',
    'transferred_to' => 'Transferred to :attribute',
    'bulk_update' => 'Bulk Employee Update',
    'bulk_create_user_account' => 'Bulk Create User Account',
    'bulk_update_user_account' => 'Bulk Update User Account',
    'verification' => [
        'verified_by' => 'Verified By',
        'verified_at' => 'Verified At',
        'props' => [
            'status' => 'Status',
            'comment' => 'Comment',
        ],
        'statuses' => [
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'pending' => 'Pending',
        ],
        'actions' => [
            'verify' => 'Verify',
            'reject' => 'Reject',
        ],
    ],
    'audience_types' => [
        'all' => 'All Employee',
        'department_wise' => 'Department Wise Employee',
        'designation_wise' => 'Designation Wise Employee',
        'employee_wise' => 'Employee Wise',
    ],
    'department' => [
        'department' => 'Department',
        'departments' => 'Departments',
        'module_title' => 'Manage all Departments',
        'module_description' => 'Departments are division of your company dealing with a specific area of activity.',
        'module_example' => 'Admin, Finance, Human Resource are some examples of Departments.',
        'global_info' => 'Global departments are available to all schools.',
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'global' => 'Global',
            'description' => 'Description',
        ],
    ],
    'designation' => [
        'designation' => 'Designation',
        'designations' => 'Designations',
        'module_title' => 'Manage all Designations',
        'module_description' => 'Designations are the official job titles given to employees of your company.',
        'module_example' => 'Chief Executive Officer, Director, Manager are some examples of Designations.',
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'parent' => 'Parent',
            'description' => 'Description',
        ],
    ],
    'status' => 'Status',
    'statuses' => [
        'active' => 'Active',
        'inactive' => 'Inactive',
    ],
    'type' => 'Type',
    'scope' => 'Scope',
    'types' => [
        'administrative' => 'Administrative Staff',
        'teaching' => 'Teaching Staff',
        'support' => 'Support Staff',
    ],
    'config' => [
        'config' => 'Config',
        'general' => 'General',
        'props' => [
            'number_prefix' => 'Code Number Prefix',
            'number_suffix' => 'Code Number Suffix',
            'number_digit' => 'Code Number Digit',
            'global_code_number' => 'Global Code Number',
            'manual_code_number' => 'Manual Code Number',
            'enable_unique_id_fields' => 'Enable Unique ID Fields',
            'unique_id_number1_enabled' => 'Unique ID 1 Enabled',
            'unique_id_number2_enabled' => 'Unique ID 2 Enabled',
            'unique_id_number3_enabled' => 'Unique ID 3 Enabled',
            'unique_id_number4_enabled' => 'Unique ID 4 Enabled',
            'unique_id_number5_enabled' => 'Unique ID 5 Enabled',
            'unique_id_number1_label' => 'Unique ID 1 Label',
            'unique_id_number2_label' => 'Unique ID 2 Label',
            'unique_id_number3_label' => 'Unique ID 3 Label',
            'unique_id_number4_label' => 'Unique ID 4 Label',
            'unique_id_number5_label' => 'Unique ID 5 Label',
            'unique_id_number1_required' => 'Unique ID 1 Required',
            'unique_id_number2_required' => 'Unique ID 2 Required',
            'unique_id_number3_required' => 'Unique ID 3 Required',
            'unique_id_number4_required' => 'Unique ID 4 Required',
            'unique_id_number5_required' => 'Unique ID 5 Required',
            'allow_employee_to_submit_contact_edit_request' => 'Allow employee to submit contact edit request',
            'default_employee_types' => 'Default Employee Types',
        ],
    ],
    'addition_types' => [
        'new' => 'New Employee',
        'existing' => 'Existing Employee',
        'other_team_member' => 'Existing Employee from different Institute',
    ],
    'addition_scopes' => [
        'guest' => 'Guest Employee',
        'transfer' => 'Transfer Employee',
    ],
    'guest_scope_info' => 'Guest employee will act as part time employee for this new institute and also work for previous institute as earlier.',
    'transfer_scope_info' => 'Transfer employee will move completely to this new institute on given date of joining and will not be part of previous institute.',
    'props' => [
        'name' => 'Employee Name',
        'number' => 'Code Digit',
        'code_number' => 'Employee Code',
        'joining_date' => 'Date of Joining',
        'leaving_date' => 'Date of Leaving',
    ],
    'employment_status' => [
        'employment_status' => 'Employment Status',
        'module_title' => 'Manage all Employment Status',
        'module_description' => 'Employment Status is a relationship between your company & your employee.',
        'module_example' => 'Permanent, Probation, Contract are some examples of Employment Status.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'employment_type' => [
        'employment_type' => 'Employment Type',
        'module_title' => 'Manage all Employment Types',
        'module_description' => 'Employment Types are the nature of employment your company offers to your employees.',
        'module_example' => 'Full Time, Part Time, Interns are some examples of Employment Types.',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'group' => [
        'group' => 'Employee Group',
        'groups' => 'Employee Groups',
        'module_title' => 'List all Employee Groups',
        'module_description' => 'Manage all Employee Groups',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'dialogue_category' => [
        'dialogue_category' => 'Dialogue Category',
        'dialogue_categories' => 'Dialogue Categories',
        'module_title' => 'List all Dialogue Categories',
        'module_description' => 'Manage all Dialogue Categories',
        'props' => [
            'name' => 'Name',
            'description' => 'Description',
        ],
    ],
    'qualification' => [
        'qualification' => 'Qualification',
        'qualifications' => 'Qualifications',
        'employee_qualifications' => 'Employee Qualifications',
        'module_title' => 'Manage all Employee Qualification Records',
        'module_description' => 'Keep the documents related to your employee\'s qualification.',
        'props' => [
            'course' => 'Course',
            'session' => 'Session',
            'institute' => 'Institute',
            'previous_institute' => 'Previous Institute',
            'institute_address' => 'Institute Address',
            'type' => 'Type',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'affiliated_to' => 'Affiliated To',
            'result' => 'Result',
            'marks' => 'Marks',
            'total_marks' => 'Total Marks',
            'obtained_marks' => 'Obtained Marks',
            'failed_subjects' => 'Failed Subjects',
            'failed_subject_info' => 'If failed in any subject, please mention the subject name here.',
            'is_submitted_original' => 'Submitted Original',
        ],
    ],
    'document_type' => [
        'document_type' => 'Document Type',
        'module_title' => 'Manage all Document Types',
        'module_description' => 'Document Types are the different categories of documents your company wish to store for the employees.',
        'module_example' => 'Resume, Salary Certificate, Experience Certificates are some examples of Document Types.',
        'props' => [
            'name' => 'Name',
            'expiry_date' => 'Expiry Date',
            'number' => 'Number',
            'number_format' => 'Number Format',
            'alert_days_before_expiry' => 'Days to Alert Before Expiry',
            'description' => 'Description',
        ],
    ],
    'dialogue' => [
        'dialogue' => 'Dialogue',
        'module_title' => 'Manage all Dialogues',
        'module_description' => 'Get all the dialogues related to your employees.',
        'props' => [
            'title' => 'Title',
            'date' => 'Date',
            'category' => 'Category',
            'description' => 'Description',
        ],
    ],
    'document' => [
        'document' => 'Document',
        'documents' => 'Documents',
        'employee_documents' => 'Employee Documents',
        'module_title' => 'Manage all Employee Documents',
        'module_description' => 'Categorize the documents related to your employees.',
        'expired' => 'Expired',
        'expiring_soon' => 'Expiring Soon',
        'expiring_in_days' => 'Expiring in :attribute day(s)',
        'props' => [
            'title' => 'Title',
            'number' => 'Number',
            'issue_date' => 'Issue Date',
            'start_date' => 'Validity Start',
            'end_date' => 'Validity End',
            'expiry_in_days' => 'Expiry in Days',
            'issue_date_between' => 'Issue Date Between',
            'start_date_between' => 'Validity Start Between',
            'end_date_between' => 'Validity End Between',
            'is_submitted_original' => 'Submitted Original',
            'description' => 'Description',
            'comment' => 'Comment',
        ],
    ],
    'experience' => [
        'experience' => 'Experience',
        'experiences' => 'Experiences',
        'module_title' => 'Manage all Employee Experience Records',
        'module_description' => 'Keep records of your employee\'s previous experience.',
        'props' => [
            'headline' => 'Headline',
            'title' => 'Title',
            'location' => 'Location',
            'organization_name' => 'Organization Name',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'job_profile' => 'Job Profile',
            'is_submitted_original' => 'Submitted Original',
        ],
    ],
    'could_not_edit_self_service_upload' => 'Could not edit self service upload record.',
    'record' => [
        'record' => 'Employment',
        'module_title' => 'Manage all Employment Records',
        'module_description' => 'Keep records of promotion, transfer of your employees.',
        'start_date_is_same_as_previous_start_date' => 'Employment start date must be different from previous start date.',
        'end_date_lt_start_date' => 'End date must be greater than start date.',
        'start_date_lt_previous_start_date' => 'Employment start date must be greater than previous start date.',
        'could_not_perform_if_no_change' => 'Could not perform this operation as there is no change in employment record.',
        'could_not_perform_if_employment_ended' => 'Could not perform this operation as employment has already ended.',
        'props' => [
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'period' => 'Period',
            'duration' => 'Duration',
            'remarks' => 'Remarks',
            'end' => 'End Employment',
        ],
    ],
    'account' => [
        'account' => 'Account',
        'accounts' => 'Accounts',
        'module_title' => 'Manage all Account Records',
        'module_description' => 'Keep all account related information of your employees.',
        'could_not_delete_primary_account' => 'Could not delete primary account.',
    ],
    'leave' => [
        'leave' => 'Leave',
        'half_day_leave' => 'Half Day Leave',
        'on_leave' => 'On Leave',
        'leave_without_pay' => 'Leave Without Pay',
        'leave_without_pay_short' => 'LWP',
        'status_detail' => 'The leave request is :attribute.',
        'request' => [
            'undo' => 'Undo',
            'approved_request' => 'Approved Leave Request',
            'request' => 'Leave Request',
            'employee_request' => 'Employee Leave Request',
            'module_title' => 'Manage all Leave Requests',
            'module_description' => 'Leave requests submitted by your employees can be approved, rejected by authorized employee.',
            'action' => 'Action',
            'status_is_not_requested' => 'Could not update leave request if status is not requested.',
            'range_exists' => 'Leave request for the employee already exists between :start and :end.',
            'half_day_invalid' => 'Half day leave request cannot be more than one day.',
            'half_day_not_allowed' => 'Half day leave is not allowed.',
            'could_not_perform_if_status_updated' => 'Could not perform this operation if status is already updated.',
            'could_not_perform_if_payroll_generated' => 'Could not perform this operation if payroll is generated for this duration.',
            'approval_tip' => 'If approved/partially approved and leave balance is exhausted, then it will be considered as LWP (Leave Without Pay).',
            'invalid_date' => 'Selected date is out of range.',
            'past_date_not_allowed' => 'Cannot request leave for past date more than :attribute days.',
            'request_already_submitted' => 'Leave request :attribute is already submitted and pending for approval.',
            'approval_request_info' => 'Leave request needs to be approved via approval request :attribute.',
            'could_not_perform_if_approval_processed' => 'Could not perform this operation if approval request is processed or under processing.',
            'statuses' => [
                'requested' => 'Requested',
                'rejected' => 'Rejected',
                'approved' => 'Approved',
                'partially_approved' => 'Partially Approved',
                'withdrawn' => 'Withdrawn',
            ],
            'props' => [
                'start_date' => 'Start Date',
                'end_date' => 'End Date',
                'approved_dates' => 'Approved Dates',
                'status' => 'Status',
                'reason' => 'Reason',
                'requester' => 'Requester',
                'approver' => 'Approver',
                'comment' => 'Comment',
                'period' => 'Period',
                'duration' => 'Duration',
                'half_day' => 'Half Day',
                'balance' => 'Balance',
            ],
        ],
        'allocation' => [
            'allocation' => 'Leave Allocation',
            'module_title' => 'Manage all Leave Allocation',
            'module_description' => 'Assign leave allocation to your employees for a particular duration.',
            'range_exists' => 'Leave allocation for the employee already exists between :start and :end.',
            'use_count_gt_allocated' => 'Allotted leave :allotted cannot less than use count :used and pending request count.',
            'start_date_gt_first_leave_request_date' => 'Start date cannot greater than first leave request date :date.',
            'end_date_lt_last_leave_request_date' => 'End date cannot less than last leave request date :date.',
            'could_not_perform_if_leave_requested' => 'Could not perform this operation if leave request is already made.',
            'could_not_perform_if_leave_utilized' => 'Could not perform this operation if leave is already utilized.',
            'could_not_delete_if_utilized' => 'Could not delete leave allocation if it is utilized.',
            'props' => [
                'start_date' => 'Start Date',
                'end_date' => 'End Date',
                'description' => 'Description',
                'allotted' => 'Leaves Allotted',
                'used' => 'Leaves Used',
                'balance' => 'Leaves Balance',
            ],
        ],
        'config' => [
            'config' => 'Config',
            'props' => [
                'allow_employee_request_leave_with_exhausted_credit' => 'Allow Employees to Request Leave with Exhausted Credit',
                'allow_employee_half_day_leave' => 'Allow Employees to Request Half Day Leave',
                'attendance_past_day_limit' => 'No of days to request leave in past',
            ],
        ],
        'type' => [
            'type' => 'Leave Type',
            'module_title' => 'Manage all Leave Types',
            'module_description' => 'Leave Type defines the category of each type of leave available to employees of your company.',
            'module_example' => 'Sick leave, Casual leave, Maternity leave are some examples of Leave Types.',
            'no_allocation_found' => 'Could not find any leave allocation for this leave type.',
            'balance_exhausted' => 'Available leave balance is :balance, cannot request for :duration day(s) leave.',
            'props' => [
                'name' => 'Name',
                'code' => 'Code',
                'alias' => 'Alias',
                'description' => 'Description',
            ],
        ],
    ],
    'attendance' => [
        'attendance' => 'Attendance',
        'attendances' => 'Attendances',
        'employee_attendance' => 'Employee Attendance',
        'module_title' => 'List all Employee Attendance',
        'module_description' => 'Filter & get your employee\'s monthly attendance record either day wise or attendance head wise.',
        'is_time_based' => 'Time based Attendance',
        'mark' => 'Mark Attendance',
        'mark_production' => 'Mark Production based Attendance',
        'filter_record' => 'Filter records to get list of employee.',
        'not_marked' => 'Attendance not marked for given data.',
        'could_not_perform_if_payroll_generated' => 'Could not perform this operation as payroll is generated.',
        'could_not_perform_if_attendance_synched' => 'Could not remove attendance as attendance is synched.',
        'qr_code_expired' => 'QR Code expired.',
        'day_wise' => 'Day Wise',
        'payable_days' => 'Payable Days',
        'not_available' => 'Not Available',
        'has_forced_attendance' => 'Has Forced Attendance',
        'config' => [
            'config' => 'Config',
            'props' => [
                'allow_employee_clock_in_out' => 'Allow Employees to Clock In/Out',
                'duration_between_clock_request' => 'Duration between Clock In/Out Request',
                'allow_employee_clock_in_out_via_device' => 'Allow Employees to Clock In/Out via Device',
                'enable_qr_code_attendance' => 'Enable QR Code Attendance',
                'has_dynamic_qr_code' => 'Use Dynamic QR Code',
                'qr_code_expiry_duration' => 'QR Code Expiry Duration (Seconds)',
                'dynamic_qr_code_tip' => 'If enabled, a new QR Code will be generated dynamically after every given duration.',
                'late_grace_period' => 'Grace Period (Late)',
                'late_grace_period_tip' => 'Arrival time in minutes after which attendance is considered as late',
                'early_leaving_grace_period' => 'Grace Period (Early Leaving)',
                'early_leaving_grace_period_tip' => 'Leaving time in minutes before which attendance is considered as early leaving',
                'present_grace_period' => 'Grace Period (Overall)',
                'present_grace_period_tip' => 'Working time in minutes before which attendance is considered as present',
                'enable_geolocation_timesheet' => 'Enable Geolocation Timesheet',
                'geolocation_latitude' => 'Geolocation Latitude',
                'geolocation_longitude' => 'Geolocation Longitude',
                'geolocation_radius' => 'Geolocation Radius',
            ],
        ],
        'props' => [
            'date' => 'Date of Attendance',
            'remarks' => 'Remarks',
            'value' => 'Value',
        ],
        'categories' => [
            'present' => 'Present',
            'holiday' => 'Holiday',
            'absent' => 'Absent',
            'leave' => 'Leave',
            'half_day' => 'Half Day',
            'production_based_earning' => 'Production based Earning',
            'production_based_deduction' => 'Production based Deduction',
        ],
        'sub_categories' => [
            'late' => 'Late',
            'early_leaving' => 'Early Leaving',
            'overtime' => 'Overtime',
        ],
        'production_units' => [
            'hourly' => 'Hourly',
        ],
        'type' => [
            'type' => 'Attendance Type',
            'types' => 'Attendance Types',
            'module_title' => 'Manage all Attendance Types',
            'module_description' => 'Attendance Type defines the category of each type of attendance available to employees of your company.',
            'module_example' => 'Present, Late, Absent are some examples of Attendance Types.',
            'could_not_perform_if_attendance_is_marked' => 'Could not perform this operation if attendance is marked.',
            'props' => [
                'name' => 'Name',
                'alias' => 'Alias',
                'code' => 'Code',
                'color' => 'Color',
                'category' => 'Category',
                'unit' => 'Unit',
                'description' => 'Description',
            ],
        ],
        'timesheet' => [
            'timesheet' => 'Timesheet',
            'timesheets' => 'Timesheets',
            'recently_marked' => 'You have recently marked attendance.',
            'could_not_perform_without_work_shift' => 'Could not find any work shift.',
            'start_time_should_less_than_end_time' => 'Start time should less than end time.',
            'overnight_start_time_should_greater_than_end_time' => 'Start time should greater than end time for overnight shift.',
            'range_exists' => 'Timesheet already exists between :start and :end.',
            'could_not_perform_if_empty_out_at' => 'Could not perform this operation if any timesheet out time is empty.',
            'could_not_perform_if_attendance_synched' => 'Could not perform this operation as attendance is already synched.',
            'max_sync_count_limit_exceed' => 'Max sync count limit exceed.',
            'choose_date_range_to_sync' => 'Filter by date range to sync timesheet.',
            'already_synched' => 'Timesheet already synched for given employee on date.',
            'module_title' => 'Manage all Timesheets',
            'module_description' => 'Timesheet is the record of employee\'s attendance for a particular day.',
            'geolocation_not_supported' => 'Sorry! Your browser doesn\'t support Geolocation.',
            'unable_to_detect_geolocation' => 'Unable to detect your current location.',
            'could_not_mark_attendance_outside_geolocation' => 'You are :distance mtr away. Could not mark attendance outside geolocation.',
            'minimum_diff_between_clock_in_out' => 'Minimum difference between clock in and clock out time should be :attribute minutes.',
            'statuses' => [
                'ok' => 'OK',
                'missing_attendance_type' => 'Missing Attendance Type',
                'manual_attendance' => 'Manual Attendance',
                'already_synched' => 'Already Synched',
            ],
            'props' => [
                'manual' => 'Manual',
                'clock_in' => 'Clock In',
                'clock_out' => 'Clock Out',
                'in_at' => 'In at',
                'out_at' => 'Out at',
                'date' => 'Date',
                'duration' => 'Duration',
                'remarks' => 'Remarks',
            ],
        ],
        'work_shift' => [
            'work_shift' => 'Work Shift',
            'work_shifts' => 'Work Shifts',
            'module_title' => 'Manage all Work Shifts',
            'module_description' => 'Work Shifts are the durations of time in which employees are expected to work.',
            'start_time_should_less_than_end_time' => 'Start time should less than end time.',
            'overnight_start_time_should_greater_than_end_time' => 'Start time should greater than end time for overnight shift.',
            'all_days_should_be_filled' => 'There are some missing or mismatch days in records.',
            'range_exists' => 'Work Shift for the employee already exists between :start and :end.',
            'assign' => 'Assign Work Shift',
            'props' => [
                'name' => 'Name',
                'code' => 'Code',
                'start_time' => 'Start Time',
                'end_time' => 'End Time',
                'start_date' => 'Start Date',
                'end_date' => 'End Date',
                'is_holiday' => 'Holiday',
                'is_overnight' => 'Overnight',
                'description' => 'Description',
                'remarks' => 'Remarks',
            ],
        ],
    ],
    'payroll' => [
        'payroll' => 'Payroll',
        'process' => 'Process Payroll',
        'salary_sheet' => 'Salary Sheet',
        'module_title' => 'Manage all Payrolls',
        'module_description' => 'Generate employee\'s Payroll based on the Attendance & Leave records for a particular duration.',
        'max_employee_limit_exceeded_for_salary_sheet' => 'Max employee limit exceeded for salary sheet.',
        'could_not_perform_if_payroll_generated_for_later_date' => 'Could not perform this operation if payroll already generated for later date.',
        'range_exists' => 'Payroll for the employee already generated between :start and :end.',
        'pending_leave_request_exists_in_given_date_range' => 'Pending leave request exists in given date range.',
        'salary_slip' => 'Salary Slip',
        'authorized_signatory' => 'Authorized Signatory',
        'footer_info' => 'This is a computer generated document and does not require any signature.',
        'not_processed' => 'Payroll is not processed.',
        'under_process' => 'Payroll is under process.',
        'props' => [
            'code_number' => 'Payroll #',
            'amount' => 'Amount',
            'date' => 'Date',
            'total' => 'Total',
            'paid' => 'Paid',
            'balance' => 'Balance',
            'status' => 'Status',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'remarks' => 'Remarks',
            'period' => 'Period',
            'duration' => 'Duration',
            'ignore_attendance' => 'Ignore Attendance',
            'batch_uuid' => 'Batch ID',
            'total' => 'Total',
            'salary_period' => 'Salary Period',
            'payment_advice_period' => 'Period',
            'bank_details' => 'Bank Details',
            'account_details' => 'Account Details',
        ],
        'transaction' => [
            'transaction' => 'Transaction',
            'props' => [
                'amount' => 'Amount',
            ],
        ],
        'variables' => [
            'working_days' => 'Working Days',
            'monthly_days' => 'Monthly Days',
            'gross_earning' => 'Gross Earning',
            'gross_deduction' => 'Gross Deduction',
            'net_salary' => 'Net Salary',
            'total_expense' => 'Total Expense',
            'employee_contribution' => 'Employee Contribution',
            'employer_contribution' => 'Employer Contribution',
            'earning_component' => 'Earning Component',
            'deduction_component' => 'Deduction Component',
        ],
        'statuses' => [
            'initiated' => 'Initiated',
            'processing' => 'Processing',
            'processed' => 'Processed',
            'failed' => 'Failed',
        ],
        'pay_head' => [
            'pay_head' => 'Pay Head',
            'module_title' => 'Manage all Pay Heads',
            'module_description' => 'Pay Head defines the components constituting salary structure of the employees of your company.',
            'module_example' => 'Basic Salary, Dearness Allowance, Provident Fund are some examples of Pay Heads.',
            'could_not_perform_if_associated_with_salary_template' => 'Could not perform this operation if pay head is associated with salary template.',
            'props' => [
                'name' => 'Name',
                'code' => 'Code',
                'alias' => 'Alias',
                'category' => 'Category',
                'description' => 'Description',
            ],
            'categories' => [
                'earning' => 'Earning',
                'deduction' => 'Deduction',
                'employee_contribution' => 'Employee Contribution',
                'employer_contribution' => 'Employer Contribution',
            ],
            'types' => [
                'not_applicable' => 'Not Applicable',
                'attendance_based' => 'Attendance Based',
                'flat_rate' => 'Flat Rate',
                'user_defined' => 'User Defined',
                'computation' => 'Computation',
                'production_based' => 'Production Based',
            ],
        ],
        'salary' => 'Salary',
        'salary_template' => [
            'salary_template' => 'Salary Template',
            'module_title' => 'Manage all Salary Templates',
            'module_description' => 'Salary Templates are predefined format of different pay heads used to create salary structure for your employees.',
            'invalid_computation' => 'Invalid computation found.',
            'hourly_payroll_info' => 'This salary template is used for hourly payroll.',
            'conditional_pay_head_info' => 'This pay head will be calculated based on the condition.',
            'earning_component_cannot_be_referenced_in_earning_pay_head' => 'Earning component cannot be referenced in earning pay head.',
            'deduction_component_cannot_be_referenced_in_earning_pay_head' => 'Deduction component cannot be referenced in earning pay head.',
            'deduction_component_cannot_be_referenced_in_deduction_pay_head' => 'Deduction component cannot be referenced in deduction pay head.',
            'computation_contains_self_pay_head' => 'Computation contains self pay head.',
            'conditional_formula_if' => 'If :pay_head is :condition :value',
            'conditional_formula_then' => 'then :formula',
            'variable_info' => 'You can use variables in the formula field. Variables are : :variable',
            'props' => [
                'name' => 'Name',
                'alias' => 'Alias',
                'description' => 'Description',
                'type' => 'Type',
                'hourly_payroll' => 'Hourly Payroll',
                'computation' => 'Computation',
                'min_value' => 'Min Value',
                'max_value' => 'Max Value',
                'has_range' => 'Has Range',
                'doesnt_have_range' => 'Does not have range',
                'has_condition' => 'Conditional',
                'operator' => 'Operator',
                'value' => 'Value',
                'condition' => 'Condition',
                'reference_pay_head' => 'Reference Pay Head',
                'conditional_value' => 'Conditional Value or Formula',
                'as_total' => 'As Total',
                'as_component' => 'As Component',
            ],
        ],
        'salary_structure' => [
            'salary_structure' => 'Salary Structure',
            'module_title' => 'Manage all Salary Structures',
            'module_description' => 'Salary structure is the details of the salary being offered, in terms of the breakup of the different components constituting the compensation.',
            'could_not_perform_if_defined_for_later_date' => 'Could not perform this operation if salary structure is already defined for later date.',
            'could_not_perform_if_payroll_generated' => 'Could not perform this operation if payroll already generated before this date.',
            'could_not_perform_if_payroll_generated_with_salary_structure' => 'Could not perform this operation if payroll already generated with this salary structure.',
            'hourly_pay_amount' => 'Hourly Pay :attribute',
            'hourly_payroll_info' => 'This salary structure has hourly pay of :attribute.',
            'working_hours' => 'Working Hours',
            'units' => [
                'monthly' => 'Monthly',
                'hourly' => 'Hourly',
            ],
            'props' => [
                'effective_date' => 'Effective Date',
                'hourly_pay' => 'Hourly Pay',
                'net_earning' => 'Net Earning',
                'net_deduction' => 'Net Deduction',
                'net_employee_contribution' => 'Employee Contribution',
                'net_employer_contribution' => 'Employer Contribution',
                'net_salary' => 'Net Salary',
                'total_expense' => 'Total Expense',
                'amount' => 'Amount',
                'description' => 'Description',
            ],
        ],
        'payment_advice' => 'Payment Advice',
        'config' => [
            'props' => [
                'code_number' => 'Payroll Number',
                'number_prefix' => 'Payroll Number Prefix',
                'number_suffix' => 'Payroll Number Suffix',
                'number_digit' => 'Payroll Number Digit',
                'payhead_round_off' => 'Payhead Round Off',
                'show_payroll_as_total_component' => 'As Total Component in Payroll',
            ],
        ],
    ],
    'incharge' => [
        'incharge' => 'Incharge',
        'incharges' => 'Incharges',
        'module_title' => 'List all Incharges',
        'module_description' => 'Manage all Incharges',
        'duplicate' => 'Duplicate record found.',
        'period_not_ended' => 'Previous incharge period not yet ended.',
        'overlapping_period' => 'Previous incharge period is overlapping with given period.',
        'props' => [
            'period' => 'Period',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'remarks' => 'Remarks',
        ],
    ],
    'edit_info' => 'If you want to edit any information, you can submit a request here.',
    'upload_document_info' => 'You can also upload document for proof of your edit request.',
    'edit_request' => [
        'edit_request' => 'Edit Request',
        'module_title' => 'List all Edit Requests',
        'module_description' => 'Manage all Edit Requests for Employee Information',
        'edit_info' => 'If you want to edit any information, you can submit a request here.',
        'upload_document_info' => 'You can also upload document for proof of your edit request.',
        'submitted' => 'Your request for edit information is submitted and applied after approval.',
        'already_pending' => 'You have already submitted a request for edit information.',
        'request_by' => 'Request By',
        'request_by_name' => 'Request By :attribute',
        'already_processed' => 'This request is already processed.',
        'statuses' => [
            'pending' => 'Pending',
            'approve' => 'Approve',
            'reject' => 'Reject',
        ],
        'props' => [
            'action' => 'Action',
            'comment' => 'Comment',
            'status' => 'Status',
        ],
    ],
];
