<?php

return [
    'config' => 'Config',
    'auth' => [
        'auth' => 'Authentication',
        'auth_config' => 'Auth Configuration',
        'auth_info' => 'Auth related configuration',
        'auth_config' => 'Authentication Configuration',
        'session_lifetime_hint' => 'Duration in minutes for user login session is valid.',
        'registration_tip' => 'If you want any one to register in your application and access the application, then enable this option.',
        'props' => [
            'enable_reset_password' => 'Reset Password',
            'enable_two_factor_security' => 'Two Factor Security',
            'two_factor_security_lifetime' => 'Two Factor Security Lifetime',
            'enable_screen_lock' => 'Screen Lock',
            'enable_oauth_login' => 'oAuth Login',
            'enable_sms_otp_login' => 'Login with OTP via SMS',
            'enable_email_otp_login' => 'Login with OTP via Email',
            'session_lifetime' => 'Session Lifetime',
            'reset_password_token_lifetime' => 'Reset Password Token Lifetime',
            'screen_lock_timeout' => 'Screen Lock Timeout',
            'login_with_client' => 'Login with :attribute',
            'client_id' => ':attribute Client ID',
            'client_secret' => ':attribute Client Secret',
            'callback_url' => ':attribute Callback URL',
            'enable_oauth' => 'Enable :attribute oAuth',
            'enable_registration' => 'Registration',
            'enable_registration_terms' => 'Show Terms on Registration',
            'enable_email_verification' => 'Email Verification',
            'enable_account_approval' => 'Account Approval',
            'enable_otp_login' => 'OTP Login',
            'enable_sms_otp_login' => 'SMS OTP Login',
            'enable_email_otp_login' => 'Email OTP Login',
            'otp_login_lifetime' => 'OTP Lifetime',
            'otp_login_lifetime_hint' => 'Duration in minutes for OTP is valid.',
            'login_throttle_max_attempts' => 'Login Throttle Max Attempt',
            'login_throttle_lock_timeout' => 'Login Throttle Lock Timeout (Minutes)',
            'login_throttle_max_attempts_hint' => 'Maximum number of attempts allowed for login.',
            'login_throttle_lock_timeout_hint' => 'Duration in minutes for login throttle lock.',
            'reset_password_token_lifetime_hint' => 'Duration in minutes for reset password token is valid.',
        ],
    ],
    'general' => [
        'general' => 'General Config',
        'general_config' => 'General Configuration',
        'general_info' => 'This information will be displayed publicly so be careful what you share.',
        'address' => 'Address',
        'address_info' => 'This address will be displayed publicly.',
        'contact' => 'Contact Details',
        'contact_info' => 'This contact details will be displayed publicly.',
        'financial_year' => 'Financial Year',
        'financial_year_info' => 'Used to identify the financial year of the organization.',
        'props' => [
            'app_name' => 'App Name',
            'app_description' => 'Description',
            'app_email' => 'Email',
            'app_phone' => 'Phone',
            'app_fax' => 'Fax',
            'app_website' => 'Website',
            'app_address_line1' => 'Address Line 1',
            'app_address_line2' => 'Address Line 2',
            'app_city' => 'City',
            'app_state' => 'State',
            'app_zipcode' => 'Zipcode',
            'app_country' => 'Country',
            'meta_author' => 'Meta Author',
            'meta_description' => 'Meta Description',
            'meta_keywords' => 'Meta Keywords',
            'financial_year_code' => 'Financial Year Code',
        ],
    ],
    'template' => [
        'template' => 'Template',
        'statuses' => [
            'enabled' => 'Enabled',
            'disabled' => 'Disabled',
        ],
    ],
    'mail' => [
        'mail' => 'Mail Config',
        'mail_config' => 'Mail Configuration',
        'mail_info' => 'Configure mail to send emails from the system.',
        'smtp' => 'SMTP Configuration',
        'mailgun' => 'Mailgun Configuration',
        'test_connection' => 'Test Mail Connection',
        'test_mail_sent' => 'Test mail sent successfully. Your mail configuration is working.',
        'props' => [
            'driver' => 'Mail Driver',
            'from_name' => 'From Name',
            'from_address' => 'From Address',
            'smtp_host' => 'Host',
            'smtp_port' => 'Port',
            'smtp_username' => 'Username',
            'smtp_password' => 'Password',
            'smtp_encryption' => 'Encryption',
            'mailgun_domain' => 'Domain',
            'mailgun_endpoint' => 'Endpoint',
            'mailgun_secret' => 'Secret',
        ],
        'template' => [
            'template' => 'Mail Template',
            'module_title' => 'Listing Mail Templates',
            'module_description' => 'A pre-defined mail layout, that may already include content which you can use to send emails.',
            'available_variables' => 'Available Variables',
            'props' => [
                'name' => 'Name',
                'subject' => 'Subject',
                'content' => 'Content',
            ],
        ],
    ],
    'sms' => [
        'sms' => 'SMS Config',
        'sms_config' => 'SMS Configuration',
        'sms_info' => 'Configure SMS Gateway to send SMS from the system.',
        'test_sms' => 'Send Test SMS',
        'test_sms_sent' => 'Test SMS sent successfully. Your SMS configuration is working.',
        'not_supported_sms_driver' => 'Not supported SMS driver.',
        'custom' => 'Custom SMS Gateway',
        'twilio' => 'Twilio SMS Gateway',
        'msg91' => 'Msg91 SMS Gateway',
        'props' => [
            'driver' => 'SMS Gateway',
            'sender_id' => 'Sender ID',
            'test_number' => 'Test Number',
            'api_key' => 'API Key',
            'api_secret' => 'API Secret',
            'api_url' => 'API URL',
            'number_prefix' => 'Number Prefix',
            'sender_id_param' => 'Sender ID Param',
            'receiver_param' => 'Receiver Param',
            'message_param' => 'Message Param',
            'template_id_param' => 'Template ID Param',
            'additional_params' => 'Additional Params',
            'api_method' => 'API Method',
            'api_headers' => 'API Headers',
            'test_template_id' => 'Test Template ID',
        ],
        'template' => [
            'template' => 'SMS Template',
            'module_title' => 'Listing SMS Templates',
            'module_description' => 'A pre-defined SMS, that may already include content which you can use to send SMS.',
            'available_variables' => 'Available Variables',
            'props' => [
                'name' => 'Name',
                'content' => 'Content',
                'subject' => 'Subject',
                'template_id' => 'Template ID',
            ],
        ],
    ],
    'whatsapp' => [
        'whatsapp' => 'WhatsApp Config',
        'whatsapp_config' => 'WhatsApp Configuration',
        'whatsapp_info' => 'Configure WhatsApp Gateway to send WhatsApp from the system.',
        'test_whatsapp' => 'Send Test WhatsApp',
        'test_whatsapp_sent' => 'Test WhatsApp message sent successfully. Your WhatsApp configuration is working.',
        'not_supported_whatsapp_provider' => 'Not supported WhatsApp provider.',
        'error_sending_message' => 'There is some error while sending WhatsApp message. Please check your WhatsApp configuration.',
        'custom' => 'Custom WhatsApp Provider',
        'pinnacle' => 'Pinnacle',
        'msg91' => 'Msg91',
        'isms_my' => 'ISMS Malaysia',
        'props' => [
            'provider' => 'WhatsApp Provider',
            'sender_id' => 'Sender ID',
            'test_number' => 'Test Number',
            'api_key' => 'API Key',
            'api_id' => 'API ID',
            'username' => 'Username',
            'password' => 'Password',
            'api_secret' => 'API Secret',
            'account_id' => 'Account ID',
            'api_url' => 'API URL',
            'identifier' => 'Identifier',
            'language_code' => 'Language Code',
            'number_prefix' => 'Number Prefix',
            'sender_id_param' => 'Sender ID Param',
            'receiver_param' => 'Receiver Param',
            'message_param' => 'Message Param',
            'template_id_param' => 'Template ID Param',
            'template_variable_param' => 'Template Variable Param',
            'additional_params' => 'Additional Params',
            'api_method' => 'API Method',
            'api_headers' => 'API Headers',
            'test_template_id' => 'Test Template ID',
        ],
        'template' => [
            'template' => 'WhatsApp Template',
            'module_title' => 'Listing WhatsApp Templates',
            'module_description' => 'A pre-defined WhatsApp, that may already include content which you can use to send WhatsApp.',
            'available_variables' => 'Available Variables',
            'props' => [
                'name' => 'Name',
                'content' => 'Content',
                'subject' => 'Subject',
                'template_id' => 'Template ID',
            ],
        ],
    ],
    'push_notification' => [
        'push_notification' => 'Push Notification',
        'push_notification_config' => 'Push Notification Configuration',
        'push_notification_info' => 'Configure push notification to send notification from the system.',
        'template' => [
            'template' => 'Push Notification Template',
            'module_title' => 'Listing Push Notification Templates',
            'module_description' => 'A pre-defined mail layout, that may already include content which you can use to send emails.',
            'available_variables' => 'Available Variables',
            'props' => [
                'name' => 'Name',
                'subject' => 'Title',
                'content' => 'Content',
            ],
        ],
    ],
    'chat' => [
        'chat' => 'Chat',
        'chat_config' => 'Chat Configuration',
        'chat_info' => 'Choose chat relateds configuration you would like to enable in the application.',
        'props' => [
            'enable_chat' => 'Enable Chat',
        ],
    ],
    'system' => [
        'system' => 'System Config',
        'system_config' => 'System Configuration',
        'system_info' => 'Choose all the configuration carefully, it will globally affect your application.',
        'credit' => 'Application Credit',
        'credit_info' => 'Credit will be displayed in the footer of all the pages.',
        'maintenance_mode' => 'Maintenance Mode',
        'maintenance_mode_info' => 'Users won\'t be able to login, Admin can login into the system during maintenance mode.',
        'invalid_currency' => 'This currency is not supported.',
        'currency_not_allowed' => 'Default currency should be in allowed currency list.',
        'setup_wizard_not_available' => 'Setup wizard is not available.',
        'not_allowed_ip' => 'This IP is not allowed to access the application.',
        'support' => 'Support',
        'support_info' => 'Enable author support will allow you to generate support token, which can be used to login as admin user. Therefore you need not to share your admin credentials with support team.',
        'props' => [
            'setup_wizard' => 'Setup Wizard',
            'maintenance_mode' => 'Maintenance Mode',
            'maintenance_mode_message' => 'Maintenance Mode Message',
            'timezone' => 'Timezone',
            'color_scheme' => 'Color Scheme',
            'date_format' => 'Date Format',
            'time_format' => 'Time Format',
            'locale' => 'Locale',
            'scroll_buttons' => 'Scroll Buttons',
            'allowed_currency' => 'Allowed Currencies',
            'default_currency' => 'Default Currency',
            'currency' => 'Currency',
            'per_page' => 'Page Length',
            'per_page_length' => 'Page Length',
            'footer_credit' => 'Footer Credit',
            'show_version_number' => 'Show Version Number',
            'dark_theme' => 'Dark Theme',
            'mini_sidebar' => 'Mini Sidebar',
            'strong_password' => 'Strong Password',
            'whitelist_ips' => 'Whitelist IPs',
            'blacklist_ips' => 'Blacklist IPs',
            'default_guest_page_layout' => 'Default Guest Page Layout',
            'page_length' => 'Page Length',
            'enable_author_support' => 'Enable Author Support',
        ],
    ],
    'feature' => [
        'feature' => 'Feature',
        'feature_config' => 'Feature Configuration',
        'feature_info' => 'Choose all the features you would like to enable in the application.',
        'props' => [
            'todo' => 'Todo',
            'backup' => 'Backup',
            'activity_log' => 'Activity Log',
            'guest_payment' => 'Guest Payment',
            'post' => 'Post',
            'guest_payment_instruction' => 'Guest Payment Instruction',
            'online_enquiry' => 'Online Enquiry',
            'online_enquiry_version' => 'Online Enquiry Version',
            'online_enquiry_instruction' => 'Online Enquiry Instruction',
            'online_registration' => 'Online Registration',
            'online_registration_version' => 'Online Registration Version',
            'online_registration_mandatory_upload_field' => 'Online Registration Mandatory Upload Field',
            'online_registration_mandatory_upload_field_info' => 'Use comma separated values to add multiple fields. These fields will be mandatory for online registration.',
            'online_registration_instruction' => 'Online Registration Instruction',
            'job_application' => 'Job Application',
            'job_application_instruction' => 'Job Application Instruction',
            'transfer_certificate_verification' => 'Transfer Certificate Verification',
            'transfer_certificate_verification_instruction' => 'Transfer Certificate Verification Instruction',
        ],
    ],
    'notification' => [
        'notification' => 'Notification',
        'notification_config' => 'Notification Configuration',
        'notification_channel' => 'Notification Channel',
        'scrolling_bar' => 'Scrolling Bar',
        'notification_info' => 'Choose notification relateds configuration you would like to enable in the application.',
        'pusher_notification' => 'Pusher Notification',
        'pusher_notification_info' => 'Pusher notification is used to notify users during chat.',
        'test_pusher_connection' => 'Test Pusher Notification',
        'test_pusher_notification_sent' => 'Test notification sent successfully. If you heard any notification sound, then pusher configuration is working.',
        'test_app_connection' => 'Test App Notification',
        'test_app_notification_sent' => 'Test notification sent successfully. If you can see notification count in the header, then app configuration is working.',
        'props' => [
            'enable_guest_notification_bar' => 'Enable Guest Notification Bar',
            'enable_app_notification_bar' => 'Enable App Notification Bar',
            'guest_notification_message' => 'Guest Notification Message',
            'app_notification_message' => 'App Notification Message',
            'enable_pusher_notification' => 'Enable Pusher Notification',
            'pusher_app_id' => 'Pusher App ID',
            'pusher_app_key' => 'Pusher App Key',
            'pusher_app_secret' => 'Pusher App Secret',
            'pusher_app_cluster' => 'Pusher App Cluster',
            'mail_notification' => 'Mail Notification',
            'sms_notification' => 'SMS Notification',
            'whatsapp_notification' => 'WhatsApp Notification',
            'mobile_push_notification' => 'Mobile Push Notification',
        ],
    ],
    'locale' => [
        'locale' => 'Locale',
        'props' => [
            'name' => 'Locale Name',
            'code' => 'Locale Code',
        ],
    ],
    'module' => [
        'module' => 'Module',
        'module_config' => 'Module Configuration',
        'module_info' => 'Configure all the modules you would like to enable in the application.',
    ],
    'social' => [
        'social' => 'Social Network',
        'social_config' => 'Social Network',
        'social_info' => 'Update your Social Network Pages, It will be available publicly.',
        'props' => [
            'facebook' => 'Facebook',
            'instagram' => 'Instagram',
            'twitter' => 'Twitter',
            'google' => 'Google',
            'linkedin' => 'LinkedIn',
            'youtube' => 'YouTube',
            'github' => 'Github',
        ],
    ],
    'asset' => [
        'asset' => 'Asset Config',
        'guest_background' => 'Guest Background',
        'guest_full_page_background' => 'Guest Full Page Background',
        'logo' => 'Logo',
        'logo_light' => 'Logo Light',
        'favicon' => 'Favicon',
        'icon' => 'Icon',
        'icon_light' => 'Icon Light',
        'asset_config' => 'Asset Upload',
        'asset_info' => 'Upload asset images.',
    ],
    'role_and_permission' => 'Role & Permission',
];
