<?php

return [
    'approval' => 'Approval',
    'approvals' => 'Approvals',
    'approver' => 'Approver',
    'approvers' => 'Approvers',
    'authorized_signatory' => 'Authorized Signatory',
    'categories' => [
        'item_based' => 'Item Based',
        'payment_based' => 'Payment Based',
        'contact_based' => 'Contact Based',
        'event_based' => 'Event Based',
        'other' => 'Other',
    ],
    'events' => [
        'student_transfer' => 'Student Transfer',
        'transfer_certificate' => 'Transfer Certificate',
        'employee_leave' => 'Employee Leave',
    ],
    'type_approval' => ':type Approval',
    'item_based_types' => [
        'item_with_quantity' => 'Item With Quantity',
        'item_without_quantity' => 'Item Without Quantity',
    ],
    'statuses' => [
        'requested' => 'Requested',
        'returned' => 'Returned',
        'hold' => 'Hold',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'cancelled' => 'Cancelled',
    ],
    'actions' => [
        'edit' => 'Edit',
        'reject' => 'Reject',
        'hold' => 'Hold',
        'cancel' => 'Cancel',
        'approve' => 'Approve',
        'return' => 'Return',
    ],
    'type' => [
        'type' => 'Type',
        'types' => 'Types',
        'module_title' => 'List all Approval Types',
        'module_description' => 'Approval Types are used to categorize and manage different types of approvals required by the organization.',
        'statuses' => [
            'active' => 'Active',
            'inactive' => 'Inactive',
        ],
        'props' => [
            'name' => 'Name',
            'event' => 'Event',
            'level' => 'Level',
            'levels' => 'Levels',
            'category' => 'Category',
            'action' => 'Action',
            'file_upload' => 'File Upload',
            'status' => 'Status',
            'due_in' => 'Due In (Days)',
            'priority' => 'Priority',
            'description' => 'Description',
            'item_based_type' => 'Item Based Type',
        ],
    ],
    'request' => [
        'request' => 'Request',
        'requests' => 'Requests',
        'pending_requests' => 'Pending Requests',
        'processed_requests' => 'Processed Requests',
        'module_title' => 'List all Approval Requests',
        'module_description' => 'Request new approval and track the status of your requests.',
        'action' => 'Action',
        'item' => 'Item',
        'props' => [
            'id_number' => 'Request ID',
            'title' => 'Title',
            'code_number' => 'Code Number',
            'type' => 'Type',
            'status' => 'Status',
            'requester' => 'Requester',
            'approver' => 'Approver',
            'priority' => 'Priority',
            'date' => 'Date',
            'amount' => 'Amount',
            'description' => 'Description',
            'comment' => 'Comment',
            'return_to' => 'Return To',
            'due_date' => 'Required before',
            'purpose' => 'Purpose',
            'duration' => 'Duration',
            'received_at' => 'Received At',
            'processed_at' => 'Processed At',
            'processed_status' => 'Processed Status',
            'payment_name' => 'Name for Payment',
        ],
        'priority' => [
            'priority' => 'Priority',
            'priorities' => 'Priorities',
            'module_title' => 'List all Approval Request Priorities',
            'module_description' => 'Create and manage approval request priorities like critical, high, medium, and low.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'group' => [
            'group' => 'Group',
            'groups' => 'Groups',
            'module_title' => 'List all Approval Request Groups',
            'module_description' => 'Create and manage approval request groups to group similar requests like stationery expense, transport expense, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'nature' => [
            'nature' => 'Nature',
            'natures' => 'Natures',
            'module_title' => 'List all Approval Request Natures',
            'module_description' => 'Create and manage approval request natures like planned, unplanned, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
        'activity' => [
            'created' => 'New request :title (:code_number) has been created by :causer.',
            'updated' => 'Request :title (:code_number) has been updated by :causer.',
            'deleted' => 'Request :title (:code_number) has been deleted by :causer.',
            'returned' => ':causer has returned the request to :return_to_employee.',
            'status_updated' => ':causer has updated the status of :title (:code_number) to :status.',
            'media_uploaded' => ':causer has uploaded media to :title (:code_number).',
            'media_removed' => ':causer has removed a media from :title (:code_number).',
        ],
    ],
    'report' => [
        'report' => 'Report',
        'reports' => 'Reports',
        'request_summary' => [
            'request_summary' => 'Request Summary Report',
            'module_title' => 'List all Request Summary',
            'module_description' => 'Manage all Request Summary',
        ],
    ],
    'config' => [
        'config' => 'Config',
        'props' => [
            'request_number_prefix' => 'Request Number Prefix',
            'request_number_digit' => 'Request Number Digit',
            'request_number_suffix' => 'Request Number Suffix',
        ],
    ],
];
