<?php

return [
    'academic' => 'Academic',
    'student_strength' => 'Student Strength',
    'principal' => 'Principal',
    'vice_principal' => 'Vice Principal',
    'principal_incharge' => 'Principal Incharge',
    'teacher' => 'Teacher',
    'class_teacher' => 'Class Teacher',
    'subject_teacher' => 'Subject Teacher',
    'config' => [
        'config' => 'Config',
        'props' => [
            'allow_listing_subject_wise_student' => 'Allow Listing Subject Wise Student',
        ],
    ],
    'period_selection' => 'Period Selection',
    'period_selection_options' => [
        'period_wise' => 'Period Wise',
        'session_wise' => 'Session Wise',
    ],
    'department' => [
        'academic_department' => 'Academic Department',
        'department' => 'Department',
        'departments' => 'Departments',
        'module_title' => 'List all Department',
        'module_description' => 'Academic Departments are divisions within an educational institution responsible for specific subject areas or fields of study. For example, the Mathematics Department, Science Department, or Humanities Department.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'alias' => 'Alias',
            'description' => 'Description',
        ],
    ],
    'program_type' => [
        'program_type' => 'Program Type',
        'program_types' => 'Program Types',
        'module_title' => 'List all Program Types',
        'module_description' => 'Program Types are categories that define the characteristics of a program. For example, K-12, Diploma, Certificate, Post Graduate, Under Graduate, etc.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'description' => 'Description',
        ],
    ],
    'program' => [
        'program' => 'Program',
        'programs' => 'Programs',
        'module_title' => 'List all Program',
        'module_description' => 'Programs are structured set of courses leading to a degree, diploma, or certification in a specific field. For example, K-12, Bachelor of Science, Diploma in Business Administration, etc.',
        'registration_disabled_info' => 'Registration is disabled for this program.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'alias' => 'Alias',
            'type' => 'Type',
            'duration' => 'Duration',
            'eligibility' => 'Eligibility',
            'benefits' => 'Benefits',
            'description' => 'Description',
        ],
    ],
    'session' => [
        'session' => 'Session',
        'sessions' => 'Sessions',
        'module_title' => 'List all Sessions',
        'module_description' => 'Sessions are academic years or periods of time that represent a specific academic calendar. For example, 2023-2024, Fall 2023, etc.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'alias' => 'Alias',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'description' => 'Description',
        ],
    ],
    'period' => [
        'period' => 'Period',
        'periods' => 'Periods',
        'current_period' => 'Current Period',
        'default_period' => 'Default Period',
        'module_title' => 'List all Periods',
        'module_description' => 'Periods are sub-divisions of a session that represent a specific academic term or semester. For example, Fall 2023, Spring 2024, etc.',
        'choose_period_info' => 'Please select a period to continue.',
        'could_not_import_from_different_program' => 'Could not import from different program.',
        'registration_disabled_info' => 'Registration is disabled for this period.',
        'session_info' => 'Session is optional. Create a session only if your session contains multiple periods/semesters/terms.',
        'multiple_country_seeder' => 'Multiple country data cannot be imported.',
        'props' => [
            'name' => 'Name',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'alias' => 'Alias',
            'start_date' => 'Start Date',
            'end_date' => 'End Date',
            'description' => 'Description',
            'seeder' => 'Seeder',
            'seeder_info' => 'Select a seeder to import data from.',
            'timesheet_timing' => 'Session Timing',
            'session_start_time' => 'Session Start Time',
            'session_end_time' => 'Session End Time',
        ],
    ],
    'division' => [
        'division' => 'Division',
        'divisions' => 'Divisions',
        'module_title' => 'List all Division',
        'module_description' => 'Divisions are groups of courses that are taught by staff. For example, Pre Primary, Primary, Secondary, Higher Secondary, etc.',
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'description' => 'Description',
            'holiday_exceptions' => 'Holiday Exceptions',
        ],
    ],
    'course' => [
        'course' => 'Course',
        'courses' => 'Courses',
        'module_title' => 'List all Course',
        'module_description' => 'Courses are specific areas of study or disciplines within a program. For example, Mathematics, Science, History, etc.',
        'registration' => 'Registration',
        'registration_fee_info' => 'Registration fee for selected course is :attribute.',
        'registration_disabled_info' => 'Registration is disabled for this course.',
        'batch_with_same_subject_info' => 'All the batches of this course have same subjects',
        'could_not_modify_same_subject_field_after_assigning_batch_wise_subject' => 'Could not modify same subject field after assigning batch wise subject.',
        'props' => [
            'name' => 'Name',
            'term' => 'Term',
            'description' => 'Description',
            'title' => 'Course Title',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'enable_registration' => 'Enable Registration',
            'registration_fee' => 'Registration Fee',
            'batch_with_same_subject' => 'Batch With Same Subject',
            'holiday_exceptions' => 'Holiday Exceptions',
        ],
    ],
    'enrollment_seat' => [
        'enrollment_seat' => 'Enrollment Seat',
        'enrollment_seats' => 'Enrollment Seats',
        'module_title' => 'List all Enrollment Seats',
        'module_description' => 'Manage all Enrollment Seats',
        'props' => [
            'seat' => 'Seat',
            'max_seat' => 'Max Seat',
            'booked_seat' => 'Booked Seat',
            'available_seat' => 'Available Seat',
            'description' => 'Description',
        ],
    ],
    'batch' => [
        'batch' => 'Batch',
        'batches' => 'Batches',
        'module_title' => 'List all Batch',
        'module_description' => 'Batches are groups of students who are enrolled in the same course and period. For example, 2023-2024, Fall 2023, etc.',
        'current_strength' => 'Current Strength :attribute',
        'props' => [
            'name' => 'Name',
            'max_strength' => 'Max Strength',
            'roll_number_prefix' => 'Roll Number Prefix',
            'description' => 'Description',
            'holiday_exceptions' => 'Holiday Exceptions',
        ],
    ],
    'subject' => [
        'subject' => 'Subject',
        'subjects' => 'Subjects',
        'module_title' => 'List all Subject',
        'module_description' => 'Subjects are specific areas of study or disciplines within a program. For example, Mathematics, Science, History, etc.',
        'allocation' => 'Subject Allocation',
        'already_allocated' => ':attribute has already subject allocated.',
        'is_not_an_elective_subject' => 'Selected subject is not an elective subject.',
        'subject_not_associated_with_batch' => 'Selected subject is not associated with the all the selected batches.',
        'record' => 'Subject Record',
        'additional_subject' => 'Additional Subject',
        'elective_subject' => 'Elective Subject',
        'elective' => 'Elective',
        'props' => [
            'name' => 'Name',
            'alias' => 'Alias',
            'code' => 'Code',
            'shortcode' => 'Short Code',
            'position' => 'Position',
            'credit' => 'Credit',
            'type' => 'Type',
            'max_class_per_week' => 'Max Class Per Week',
            'fee' => 'Subject Fee',
            'exam_fee' => 'Exam Fee',
            'course_fee' => 'Course Fee',
            'is_elective' => 'Is Elective',
            'has_no_exam' => 'Has No Exam',
            'has_grading' => 'Has Grading',
            'description' => 'Description',
        ],
        'type' => [
            'type' => 'Subject Type',
            'types' => 'Subject Types',
            'module_title' => 'Manage all Subject Types',
            'module_description' => 'Subject Types are categories that define the characteristics of a subject. For example, Theory, Practical, etc.',
            'props' => [
                'name' => 'Name',
                'description' => 'Description',
            ],
        ],
    ],
    'book_list' => [
        'book_list' => 'Book list',
        'book_lists' => 'Book lists',
        'module_title' => 'List all Book list',
        'module_description' => 'Manage all Book list',
        'types' => [
            'textbook' => 'Textbook',
            'reference_book' => 'Reference Book',
            'notebook' => 'Notebook',
        ],
        'props' => [
            'title' => 'Title',
            'author' => 'Author',
            'publisher' => 'Publisher',
            'type' => 'Type',
            'quantity' => 'Quantity',
            'pages' => 'Pages',
            'description' => 'Description',
        ],
    ],
    'incharge' => [
        'unsupported_screen_size' => 'This functionality is not supported on small screen devices. Please use a larger screen device to access this functionality.',
    ],
    'department_incharge' => [
        'department_incharge' => 'Department Incharge',
        'department_incharges' => 'Department Incharges',
        'module_title' => 'List all Department Incharges',
        'module_description' => 'Manage all Department Incharges',
    ],
    'program_incharge' => [
        'program_incharge' => 'Program Incharge',
        'program_incharges' => 'Program Incharges',
        'module_title' => 'List all Program Incharges',
        'module_description' => 'Manage all Program Incharges',
    ],
    'division_incharge' => [
        'division_incharge' => 'Division Incharge',
        'division_incharges' => 'Division Incharges',
        'module_title' => 'List all Division Incharges',
        'module_description' => 'Manage all Division Incharges',
    ],
    'course_incharge' => [
        'course_incharge' => 'Course Incharge',
        'course_incharges' => 'Course Incharges',
        'module_title' => 'List all Course Incharges',
        'module_description' => 'Manage all Course Incharges',
    ],
    'batch_incharge' => [
        'batch_incharge' => 'Batch Incharge',
        'batch_incharges' => 'Batch Incharges',
        'module_title' => 'List all Batch Incharges',
        'module_description' => 'Manage all Batch Incharges',
    ],
    'subject_incharge' => [
        'subject_incharge' => 'Subject Incharge',
        'subject_incharges' => 'Subject Incharges',
        'module_title' => 'List all Subject Incharges',
        'module_description' => 'Manage all Subject Incharges',
    ],
    'certificate' => [
        'type' => 'Type',
        'types' => [
            'transfer_certificate' => 'Transfer Certificate',
            'other' => 'Other',
        ],
        'for' => [
            'student' => 'Student',
            'employee' => 'Employee',
        ],
        'template' => [
            'template' => 'Certificate Template',
            'templates' => 'Certificate Templates',
            'module_title' => 'List all Certificate Templates',
            'module_description' => 'Manage all Certificate Templates',
            'props' => [
                'name' => 'Name',
                'type' => 'Type',
                'for' => 'For',
                'custom_field' => 'Custom Field',
                'content' => 'Content',
                'variables' => 'Variables',
                'custom_template_file' => 'Custom Template File',
                'has_custom_template_file' => 'Has Custom Template File',
                'has_custom_header' => 'Has Custom Header',
                'custom_template_file_name' => 'Custom Template File Name',
                'number_prefix' => 'Certificate Number Prefix',
                'number_digit' => 'Certificate Number Digit',
                'number_suffix' => 'Certificate Number Suffix',
            ],
        ],
        'certificate' => 'Certificate',
        'certificates' => 'Certificates',
        'module_title' => 'List all Certificates',
        'module_description' => 'Manage all Certificates',
        'custom_certificate_number_info' => 'Leave this field blank to use the default certificate number.',
        'already_exists' => 'Certificate already exists for the given details.',
        'code_number_already_exists' => 'Certificate number already exists.',
        'props' => [
            'code_number' => 'Certificate #',
            'custom_code_number' => 'Custom Certificate Number',
            'date' => 'Date',
            'to' => 'To',
            'show_label' => 'Show Label',
            'hide_label' => 'Hide Label',
        ],
        'search_placeholder' => 'Search field:value,another_field:another_value',
    ],
    'id_card' => [
        'id_card' => 'ID Card',
        'id_cards' => 'ID Cards',
        'module_title' => 'List all ID Cards',
        'module_description' => 'Manage all ID Cards',
        'card_per_page' => 'Card Per Page',
        'for' => [
            'student' => 'Student',
            'employee' => 'Employee',
            'guardian' => 'Guardian',
        ],
        'props' => [
            'height' => 'Height (cm)',
            'width' => 'Width (cm)',
        ],
        'template' => [
            'template' => 'ID Card Template',
            'templates' => 'ID Card Templates',
            'module_title' => 'List all ID Card Templates',
            'module_description' => 'Manage all ID Card Templates',
            'props' => [
                'name' => 'Name',
                'for' => 'For',
                'custom_template_file' => 'Custom Template File',
                'has_custom_template_file' => 'Has Custom Template File',
                'custom_template_file_name' => 'Custom Template File Name',
            ],
        ],
    ],
    'class_timing' => [
        'class_timing' => 'Class Timing',
        'class_timings' => 'Class Timings',
        'module_title' => 'List all Class Timings',
        'module_description' => 'Manage all Class Timings',
        'session' => 'Session',
        'break' => 'Break',
        'start_time_should_less_than_end_time' => 'Start time should be less than end time.',
        'start_time_should_greater_than_previous_session_end_time' => 'Start time should be greater than previous session end time.',
        'could_not_modify_if_allocated' => 'Could not modify if timetable is allocated.',
        'props' => [
            'name' => 'Session Name',
            'is_break' => 'Is Break',
            'start_time' => 'Start Time',
            'end_time' => 'End Time',
            'session' => 'Session',
            'session_code' => 'Code',
            'duration' => 'Duration',
            'description' => 'Description',
        ],
    ],
    'timetable' => [
        'timetable' => 'Timetable',
        'timetables' => 'Timetables',
        'allotment' => 'Allotment',
        'teacher_timetable' => 'Teacher Timetable',
        'duplicate_allotment' => 'Duplicate subject in same session.',
        'module_title' => 'List all Timetables',
        'module_description' => 'Manage all Timetables',
        'invalid_days' => 'All days of the week should be available.',
        'invalid_day' => 'Invalid day of the week.',
        'all_days_should_be_filled' => 'All days should be filled.',
        'could_not_modify_if_allocated' => 'Could not modify if subjects are allocated.',
        'timetable_not_found_for_today' => 'Timetable not defined for today.',
        'holiday_info' => ':attribute is a holiday.',
        'class_timing_not_found' => 'Could not found class timing.',
        'employee_not_assigned_to_subject' => 'Employee is not assigned to this subject.',
        'allocation' => 'Allocation',
        'props' => [
            'day' => 'Day',
            'holiday' => 'Holiday',
            'effective_date' => 'Effective Date',
            'description' => 'Description',
        ],
        'layouts' => [
            'default' => 'Default',
            'uniform' => 'Uniform',
            'merged' => 'Merged',
            'grouped' => 'Grouped',
        ],
    ],
];
