<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transport_route_passengers', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->index()->unique();

            $table->foreignId('route_id')->nullable()->constrained('transport_routes')->onDelete('cascade');
            $table->foreignId('stoppage_id')->nullable()->constrained('transport_stoppages')->onDelete('cascade');
            $table->string('direction', 20)->nullable();
            $table->nullableMorphs('model');

            $table->json('config')->nullable();
            $table->json('meta')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transport_route_passengers');
    }
};
