<?php

namespace App\Http\Resources\Mess;

use Illuminate\Http\Resources\Json\JsonResource;

class MealLogRecordResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'item' => MenuItemResource::make($this->whenLoaded('item')),
            'created_at' => \Cal::dateTime($this->created_at),
            'updated_at' => \Cal::dateTime($this->updated_at),
        ];
    }
}
