<?php

namespace App\Http\Resources\Finance;

use Illuminate\Http\Resources\Json\JsonResource;

class FeeInstallmentRecordResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'uuid' => $this->uuid,
            'name' => $this->head->name,
            'amount' => $this->amount,
            'is_optional' => $this->is_optional ? true : false,
            'installment' => FeeInstallmentResource::make($this->whenLoaded('installment')),
            'head' => FeeHeadResource::make($this->whenLoaded('head')),
            'components' => $this->getComponents(),
            'applicable_to' => $this->applicable_to,
            'created_at' => \Cal::dateTime($this->created_at),
            'updated_at' => \Cal::dateTime($this->updated_at),
        ];
    }

    private function getComponents()
    {
        if (! $this->relationLoaded('components')) {
            return [];
        }

        return $this->components->map(function ($component) {
            return [
                'uuid' => $component->uuid,
                'name' => $component->component?->name,
                'amount' => $component->amount,
                'component_uuid' => $component->component?->uuid,
            ];
        });
    }
}
