<?php

namespace App\Http\Controllers\Inventory;

use App\Http\Controllers\Controller;
use App\Services\Inventory\VendorImportService;
use Illuminate\Http\Request;

class VendorImportController extends Controller
{
    public function __invoke(Request $request, VendorImportService $service)
    {
        $service->import($request);

        if (request()->boolean('validate')) {
            return response()->success([
                'message' => trans('general.data_validated'),
            ]);
        }

        return response()->success([
            'imported' => true,
            'message' => trans('global.imported', ['attribute' => trans('inventory.vendor.vendor')]),
        ]);
    }
}
