<?php

namespace App\Concerns;

trait ModelRelation
{
    /**
     * Get all relations
     *
     * @return array
     */
    public function relations()
    {
        return [
            'Team' => 'App\Models\Team',
            'User' => 'App\Models\User',
            'Tag' => 'App\Models\Tag',
            'Comment' => 'App\Models\Comment',
            'Config' => 'App\Models\Config\Config',
            'Todo' => 'App\Models\Utility\Todo',
            'Role' => 'App\Models\Config\Role',
            'Option' => 'App\Models\Option',
            'Template' => 'App\Models\Config\Template',
            'Media' => 'App\Models\Media',
            'Post' => 'App\Models\Post\Post',
            'AcademicDepartment' => 'App\Models\Academic\Department',
            'ProgramType' => 'App\Models\Academic\ProgramType',
            'Program' => 'App\Models\Academic\Program',
            'Session' => 'App\Models\Academic\Session',
            'Period' => 'App\Models\Academic\Period',
            'Division' => 'App\Models\Academic\Division',
            'Course' => 'App\Models\Academic\Course',
            'Batch' => 'App\Models\Academic\Batch',
            'EnrollmentSeat' => 'App\Models\Academic\EnrollmentSeat',
            'Subject' => 'App\Models\Academic\Subject',
            'SubjectRecord' => 'App\Models\Academic\SubjectRecord',
            'CertificateTemplate' => 'App\Models\Academic\CertificateTemplate',
            'Certificate' => 'App\Models\Academic\Certificate',
            'ClassTiming' => 'App\Models\Academic\ClassTiming',
            'Timetable' => 'App\Models\Academic\Timetable',
            'Incharge' => 'App\Models\Incharge',
            'FeeGroup' => 'App\Models\Finance\FeeGroup',
            'FeeHead' => 'App\Models\Finance\FeeHead',
            'FeeConcession' => 'App\Models\Finance\FeeConcession',
            'FeeStructure' => 'App\Models\Finance\FeeStructure',
            'FeeInstallment' => 'App\Models\Finance\FeeInstallment',
            'FeeInstallmentRecord' => 'App\Models\Finance\FeeInstallmentRecord',
            'FeeAllocation' => 'App\Models\Finance\FeeAllocation',
            'FeeRefund' => 'App\Models\Finance\FeeRefund',
            'LedgerType' => 'App\Models\Finance\LedgerType',
            'Ledger' => 'App\Models\Finance\Ledger',
            'Transaction' => 'App\Models\Finance\Transaction',
            'Receipt' => 'App\Models\Finance\Receipt',
            'DayClosure' => 'App\Models\Finance\DayClosure',
            'BankTransfer' => 'App\Models\Finance\BankTransfer',
            'TransactionRecord' => 'App\Models\Finance\TransactionRecord',
            'TransactionPayment' => 'App\Models\Finance\TransactionPayment',
            'TransportStoppage' => 'App\Models\Transport\Stoppage',
            'TransportRoute' => 'App\Models\Transport\Route',
            'TransportCircle' => 'App\Models\Transport\Circle',
            'TransportFee' => 'App\Models\Transport\Fee',
            'Vehicle' => 'App\Models\Transport\Vehicle\Vehicle',
            'VehicleTripRecord' => 'App\Models\Transport\Vehicle\TripRecord',
            'VehicleFuelRecord' => 'App\Models\Transport\Vehicle\FuelRecord',
            'VehicleServiceRecord' => 'App\Models\Transport\Vehicle\ServiceRecord',
            'VehicleExpenseRecord' => 'App\Models\Transport\Vehicle\ExpenseRecord',
            'VehicleCaseRecord' => 'App\Models\Transport\Vehicle\CaseRecord',
            'ContactEditRequest' => 'App\Models\ContactEditRequest',
            'Contact' => 'App\Models\Contact',
            'Guardian' => 'App\Models\Guardian',
            'Account' => 'App\Models\Account',
            'Dialogue' => 'App\Models\Dialogue',
            'Document' => 'App\Models\Document',
            'Qualification' => 'App\Models\Qualification',
            'Experience' => 'App\Models\Experience',
            'Student' => 'App\Models\Student\Student',
            'StudentFee' => 'App\Models\Student\Fee',
            'StudentFeeRecord' => 'App\Models\Student\FeeRecord',
            'StudentFeePayment' => 'App\Models\Student\FeePayment',
            'Registration' => 'App\Models\Student\Registration',
            'Admission' => 'App\Models\Student\Admission',
            'StudentLeaveRequest' => 'App\Models\Student\LeaveRequest',
            'StudentServiceRequest' => 'App\Models\Student\ServiceRequest',
            'TransferRequest' => 'App\Models\Student\TransferRequest',
            'Department' => 'App\Models\Employee\Department',
            'Designation' => 'App\Models\Employee\Designation',
            'Employee' => 'App\Models\Employee\Employee',
            'EmployeeRecord' => 'App\Models\Employee\Record',
            'LeaveType' => 'App\Models\Employee\Leave\Type',
            'LeaveAllocation' => 'App\Models\Employee\Leave\Allocation',
            'LeaveRequest' => 'App\Models\Employee\Leave\Request',
            'Attendance' => 'App\Models\Employee\Attendance\Attendance',
            'AttendanceType' => 'App\Models\Employee\Attendance\Type',
            'WorkShift' => 'App\Models\Employee\Attendance\WorkShift',
            'Timesheet' => 'App\Models\Employee\Attendance\Timesheet',
            'PayHead' => 'App\Models\Employee\Payroll\PayHead',
            'Payroll' => 'App\Models\Employee\Payroll\Payroll',
            'SalaryStructure' => 'App\Models\Employee\Payroll\SalaryStructure',
            'SalaryTemplate' => 'App\Models\Employee\Payroll\SalaryTemplate',
            'StudentDiary' => 'App\Models\Resource\Diary',
            'OnlineClass' => 'App\Models\Resource\OnlineClass',
            'Assignment' => 'App\Models\Resource\Assignment',
            'AssignmentSubmission' => 'App\Models\Resource\AssignmentSubmission',
            'LessonPlan' => 'App\Models\Resource\LessonPlan',
            'LearningMaterial' => 'App\Models\Resource\LearningMaterial',
            'Download' => 'App\Models\Resource\Download',
            'Syllabus' => 'App\Models\Resource\Syllabus',
            'Holiday' => 'App\Models\Calendar\Holiday',
            'Event' => 'App\Models\Calendar\Event',
            'Incident' => 'App\Models\Discipline\Incident',
            'Enquiry' => 'App\Models\Reception\Enquiry',
            'EnquiryFollowUp' => 'App\Models\Reception\EnquiryFollowUp',
            'VisitorLog' => 'App\Models\Reception\VisitorLog',
            'GatePass' => 'App\Models\Reception\GatePass',
            'Complaint' => 'App\Models\Reception\Complaint',
            'ComplaintLog' => 'App\Models\Reception\ComplaintLog',
            'Query' => 'App\Models\Reception\Query',
            'CallLog' => 'App\Models\Reception\CallLog',
            'Correspondence' => 'App\Models\Reception\Correspondence',
            'Book' => 'App\Models\Library\Book',
            'BookAddition' => 'App\Models\Library\BookAddition',
            'BookTransaction' => 'App\Models\Library\Transaction',
            'MenuItem' => 'App\Models\Mess\MenuItem',
            'Meal' => 'App\Models\Mess\Meal',
            'MealLog' => 'App\Models\Mess\MealLog',
            'Inventory' => 'App\Models\Inventory\Inventory',
            'StockCategory' => 'App\Models\Inventory\StockCategory',
            'StockItem' => 'App\Models\Inventory\StockItem',
            'StockRequisition' => 'App\Models\Inventory\StockRequisition',
            'StockPurchase' => 'App\Models\Inventory\StockPurchase',
            'StockReturn' => 'App\Models\Inventory\StockReturn',
            'StockAdjustment' => 'App\Models\Inventory\StockAdjustment',
            'StockTransfer' => 'App\Models\Inventory\StockTransfer',
            'Communication' => 'App\Models\Communication\Communication',
            'Announcement' => 'App\Models\Communication\Announcement',
            'Block' => 'App\Models\Asset\Building\Block',
            'Floor' => 'App\Models\Asset\Building\Floor',
            'Room' => 'App\Models\Asset\Building\Room',
            'Exam' => 'App\Models\Exam\Exam',
            'ExamGrade' => 'App\Models\Exam\Grade',
            'ExamAssessment' => 'App\Models\Exam\Assessment',
            'ExamObservation' => 'App\Models\Exam\Observation',
            'ExamCompetency' => 'App\Models\Exam\Competency',
            'ExamTerm' => 'App\Models\Exam\Term',
            'ExamSchedule' => 'App\Models\Exam\Schedule',
            'ExamRecord' => 'App\Models\Exam\Record',
            'OnlineExam' => 'App\Models\Exam\OnlineExam',
            'OnlineExamQuestion' => 'App\Models\Exam\OnlineExamQuestion',
            'OnlineExamSubmission' => 'App\Models\Exam\OnlineExamSubmission',
            'HostelBlock' => 'App\Models\Hostel\Block',
            'HostelFloor' => 'App\Models\Hostel\Floor',
            'HostelRoom' => 'App\Models\Hostel\Room',
            'RoomAllocation' => 'App\Models\Hostel\RoomAllocation',
            'JobVacancy' => 'App\Models\Recruitment\Vacancy',
            'JobApplication' => 'App\Models\Recruitment\Application',
            'Gallery' => 'App\Models\Gallery',
            'Form' => 'App\Models\Form\Form',
            'FormSubmission' => 'App\Models\Form\Submission',
            'SitePage' => 'App\Models\Site\Page',
            'SiteMenu' => 'App\Models\Site\Menu',
            'SiteBlock' => 'App\Models\Site\Block',
            'Blog' => 'App\Models\Blog\Blog',
            'News' => 'App\Models\News\News',
            'Trip' => 'App\Models\Activity\Trip',
            'TripVisitor' => 'App\Models\Activity\TripVisitor',
            'ApprovalType' => 'App\Models\Approval\Type',
            'ApprovalRequest' => 'App\Models\Approval\Request',
            'ApprovalLevel' => 'App\Models\Approval\Level',
            'Task' => 'App\Models\Task\Task',
            'TaskChecklist' => 'App\Models\Task\Checklist',
            'TaskMember' => 'App\Models\Task\Member',
            'Faq' => 'App\Models\Helpdesk\Faq\Faq',
            'Ticket' => 'App\Models\Helpdesk\Ticket\Ticket',
            'TicketMessage' => 'App\Models\Helpdesk\Ticket\Message',
            'TicketAssignee' => 'App\Models\Helpdesk\Ticket\Assignee',
        ];
    }
}
