<?php

namespace App\Actions\Config\Module;

use Illuminate\Support\Arr;
use Illuminate\Validation\ValidationException;

class StoreFinanceConfig
{
    public static function handle(): array
    {
        $input = request()->validate([
            'payment_number_prefix' => 'sometimes|max:200',
            'payment_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'payment_number_suffix' => 'sometimes|max:200',
            'receipt_number_prefix' => 'sometimes|max:200',
            'receipt_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'receipt_number_suffix' => 'sometimes|max:200',
            'transfer_number_prefix' => 'sometimes|max:200',
            'transfer_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'transfer_number_suffix' => 'sometimes|max:200',
            'bank_transfer_number_prefix' => 'sometimes|max:200',
            'bank_transfer_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'bank_transfer_number_suffix' => 'sometimes|max:200',
            'enable_guest_payment' => 'boolean',
            'enable_round_off_fee_concession' => 'boolean',
            'concession_round_off_type' => 'sometimes|in:round_before_subtraction,round_after_subtraction',
            'enable_online_transaction_number' => 'boolean',
            'online_transaction_number_prefix' => 'sometimes|max:200',
            'online_transaction_number_digit' => 'sometimes|required|integer|min:0|max:9',
            'online_transaction_number_suffix' => 'sometimes|max:200',
            'enable_manual_receipt_number' => 'sometimes|boolean',
            'currency_denominations' => 'sometimes|max:500',
            'enable_bank_code1' => 'boolean',
            'bank_code1_label' => 'sometimes|required_if:enable_bank_code1,true|min:2|max:100',
            'is_bank_code1_required' => 'boolean',
            'enable_bank_code2' => 'boolean',
            'bank_code2_label' => 'sometimes|required_if:enable_bank_code2,true|min:2|max:100',
            'is_bank_code2_required' => 'boolean',
            'enable_bank_code3' => 'boolean',
            'bank_code3_label' => 'sometimes|required_if:enable_bank_code3,true|min:2|max:100',
            'is_bank_code3_required' => 'boolean',
            'enable_paypal' => 'boolean',
            'enable_live_paypal_mode' => 'boolean',
            'paypal_client' => 'required_if:enable_paypal,true',
            'paypal_secret' => 'required_if:enable_paypal,true',
            'enable_stripe' => 'boolean',
            'enable_live_stripe_mode' => 'boolean',
            'stripe_client' => 'required_if:enable_stripe,true',
            'stripe_secret' => 'required_if:enable_stripe,true',
            'enable_payzone' => 'boolean',
            'enable_live_payzone_mode' => 'boolean',
            'payzone_merchant' => 'required_if:enable_payzone,true',
            'payzone_secret_key' => 'required_if:enable_payzone,true',
            'payzone_notification_key' => 'required_if:enable_payzone,true',
            'enable_razorpay' => 'boolean',
            'enable_live_razorpay_mode' => 'boolean',
            'razorpay_client' => 'required_if:enable_razorpay,true',
            'razorpay_secret' => 'required_if:enable_razorpay,true',
            'enable_paystack' => 'boolean',
            'enable_live_paystack_mode' => 'boolean',
            'paystack_client' => 'required_if:enable_paystack,true',
            'paystack_secret' => 'required_if:enable_paystack,true',
            'enable_ccavenue' => 'boolean',
            'enable_live_ccavenue_mode' => 'boolean',
            'ccavenue_merchant' => 'required_if:enable_ccavenue,true',
            'ccavenue_client' => 'required_if:enable_ccavenue,true',
            'ccavenue_secret' => 'required_if:enable_ccavenue,true',
            'enable_billdesk' => 'boolean',
            'enable_live_billdesk_mode' => 'boolean',
            'billdesk_version' => 'required_if:enable_billdesk,true',
            'billdesk_merchant' => 'required_if:enable_billdesk,true',
            'billdesk_client' => 'required_if:enable_billdesk,true',
            'billdesk_secret' => 'required_if:enable_billdesk,true',
            'enable_billplz' => 'boolean',
            'enable_live_billplz_mode' => 'boolean',
            'billplz_client' => 'required_if:enable_billplz,true',
            'billplz_secret' => 'required_if:enable_billplz,true',
            'billplz_signature' => 'required_if:enable_billplz,true',
            'enable_amwalpay' => 'boolean',
            'enable_live_amwalpay_mode' => 'boolean',
            'amwalpay_client' => 'required_if:enable_amwalpay,true',
            'amwalpay_secret' => 'required_if:enable_amwalpay,true',
            'amwalpay_signature' => 'required_if:enable_amwalpay,true',
            'enable_hubtel' => 'boolean',
            'enable_live_hubtel_mode' => 'boolean',
            'hubtel_merchant' => 'required_if:enable_hubtel,true',
            'hubtel_client' => 'required_if:enable_hubtel,true',
            'hubtel_secret' => 'required_if:enable_hubtel,true',
        ], [
            'bank_code1_label.required_if' => __('validation.required'),
            'bank_code2_label.required_if' => __('validation.required'),
            'bank_code3_label.required_if' => __('validation.required'),
            'paypal_client.required_if' => __('validation.required'),
            'paypal_secret.required_if' => __('validation.required'),
            'stripe_client.required_if' => __('validation.required'),
            'stripe_secret.required_if' => __('validation.required'),
            'payzone_merchant.required_if' => __('validation.required'),
            'payzone_secret_key.required_if' => __('validation.required'),
            'payzone_notification_key.required_if' => __('validation.required'),
            'razorpay_client.required_if' => __('validation.required'),
            'razorpay_secret.required_if' => __('validation.required'),
            'paystack_client.required_if' => __('validation.required'),
            'paystack_secret.required_if' => __('validation.required'),
            'ccavenue_merchant.required_if' => __('validation.required'),
            'ccavenue_client.required_if' => __('validation.required'),
            'ccavenue_secret.required_if' => __('validation.required'),
            'billdesk_version.required_if' => __('validation.required'),
            'billdesk_merchant.required_if' => __('validation.required'),
            'billdesk_client.required_if' => __('validation.required'),
            'billdesk_secret.required_if' => __('validation.required'),
            'billplz_client.required_if' => __('validation.required'),
            'billplz_secret.required_if' => __('validation.required'),
            'amwalpay_client.required_if' => __('validation.required'),
            'amwalpay_secret.required_if' => __('validation.required'),
            'amwalpay_signature.required_if' => __('validation.required'),
            'hubtel_merchant.required_if' => __('validation.required'),
            'hubtel_client.required_if' => __('validation.required'),
            'hubtel_secret.required_if' => __('validation.required'),
        ], [
            'payment_number_prefix' => __('finance.transaction.config.props.payment_number_prefix'),
            'payment_number_digit' => __('finance.transaction.config.props.payment_number_digit'),
            'payment_number_suffix' => __('finance.transaction.config.props.payment_number_suffix'),
            'receipt_number_prefix' => __('finance.transaction.config.props.receipt_number_prefix'),
            'receipt_number_digit' => __('finance.transaction.config.props.receipt_number_digit'),
            'receipt_number_suffix' => __('finance.transaction.config.props.receipt_number_suffix'),
            'transfer_number_prefix' => __('finance.transaction.config.props.transfer_number_prefix'),
            'transfer_number_digit' => __('finance.transaction.config.props.transfer_number_digit'),
            'transfer_number_suffix' => __('finance.transaction.config.props.transfer_number_suffix'),
            'bank_transfer_number_prefix' => __('finance.transaction.config.props.bank_transfer_number_prefix'),
            'bank_transfer_number_digit' => __('finance.transaction.config.props.bank_transfer_number_digit'),
            'bank_transfer_number_suffix' => __('finance.transaction.config.props.bank_transfer_number_suffix'),
            'enable_guest_payment' => __('global.enable', ['attribute' => __('finance.transaction.config.props.guest_payment')]),
            'enable_round_off_fee_concession' => __('global.enable', ['attribute' => __('finance.transaction.config.props.round_off_fee_concession')]),
            'concession_round_off_type' => __('finance.transaction.config.props.concession_round_off_type'),
            'enable_online_transaction_number' => __('global.enable', ['attribute' => __('finance.transaction.config.props.online_transaction_number')]),
            'online_transaction_number_prefix' => __('finance.transaction.config.props.online_number_prefix'),
            'online_transaction_number_digit' => __('finance.transaction.config.props.online_number_digit'),
            'online_transaction_number_suffix' => __('finance.transaction.config.props.online_number_suffix'),
            'enable_manual_receipt_number' => __('global.enable', ['attribute' => __('finance.transaction.config.props.manual_receipt_number')]),
            'currency_denominations' => __('finance.transaction.config.props.currency_denominations'),
            'enable_bank_code1' => __('finance.config.props.bank_code1'),
            'bank_code1_label' => __('finance.config.props.bank_code1_label'),
            'is_bank_code1_required' => __('finance.config.props.bank_code1'),
            'enable_bank_code2' => __('finance.config.props.bank_code2'),
            'bank_code2_label' => __('finance.config.props.bank_code2_label'),
            'is_bank_code2_required' => __('finance.config.props.bank_code2'),
            'enable_bank_code3' => __('finance.config.props.bank_code3'),
            'bank_code3_label' => __('finance.config.props.bank_code3_label'),
            'is_bank_code3_required' => __('finance.config.props.bank_code3'),
            'enable_paypal' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'PayPal']),
            'enable_live_paypal_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'PayPal']),
            'paypal_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'PayPal']),
            'paypal_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'PayPal']),
            'enable_stripe' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Stripe']),
            'enable_live_stripe_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Stripe']),
            'stripe_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Stripe']),
            'stripe_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Stripe']),
            'enable_payzone' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Payzone']),
            'enable_live_payzone_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Payzone']),
            'payzone_merchant' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Payzone']),
            'payzone_secret_key' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Payzone']),
            'payzone_notification_key' => __('finance.config.props.payment_gateway_notification', ['attribute' => 'Payzone']),
            'enable_razorpay' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Razorpay']),
            'enable_live_razorpay_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Razorpay']),
            'razorpay_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Razorpay']),
            'razorpay_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Razorpay']),
            'enable_paystack' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Paystack']),
            'enable_live_paystack_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Paystack']),
            'paystack_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Paystack']),
            'paystack_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Paystack']),
            'enable_ccavenue' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'CCAvenue']),
            'enable_live_ccavenue_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'CCAvenue']),
            'ccavenue_merchant' => __('finance.config.props.payment_gateway_merchant', ['attribute' => 'CCAvenue']),
            'ccavenue_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'CCAvenue']),
            'ccavenue_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'CCAvenue']),
            'enable_billdesk' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Billdesk']),
            'enable_live_billdesk_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Billdesk']),
            'billdesk_version' => __('finance.config.props.payment_gateway_version', ['attribute' => 'Billdesk']),
            'billdesk_merchant' => __('finance.config.props.payment_gateway_merchant', ['attribute' => 'Billdesk']),
            'billdesk_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Billdesk']),
            'billdesk_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Billdesk']),
            'enable_billplz' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Billplz']),
            'enable_live_billplz_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Billplz']),
            'billplz_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Billplz']),
            'billplz_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Billplz']),
            'billplz_signature' => __('finance.config.props.payment_gateway_signature', ['attribute' => 'Billplz']),
            'enable_amwalpay' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Amwalpay']),
            'enable_live_amwalpay_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Amwalpay']),
            'amwalpay_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Amwalpay']),
            'amwalpay_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Amwalpay']),
            'amwalpay_signature' => __('finance.config.props.payment_gateway_signature', ['attribute' => 'Amwalpay']),
            'enable_hubtel' => __('finance.config.props.enable_payment_gateway', ['attribute' => 'Hubtel']),
            'enable_live_hubtel_mode' => __('finance.config.props.payment_gateway_mode', ['attribute' => 'Hubtel']),
            'hubtel_merchant' => __('finance.config.props.payment_gateway_merchant', ['attribute' => 'Hubtel']),
            'hubtel_client' => __('finance.config.props.payment_gateway_client', ['attribute' => 'Hubtel']),
            'hubtel_secret' => __('finance.config.props.payment_gateway_secret', ['attribute' => 'Hubtel']),
        ]);

        if (request()->has('currency_denominations')) {
            $inputCurrencyDenominations = explode(',', Arr::get($input, 'currency_denominations', []));
            foreach ($inputCurrencyDenominations as $denomination) {
                if (! is_numeric($denomination) || $denomination <= 0) {
                    throw ValidationException::withMessages(['currency_denominations' => trans('validation.numeric', ['attribute' => trans('finance.transaction.config.props.currency_denominations')])]);
                }
            }
        }

        return $input;
    }
}
